/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"commonNegate", "", "num", "extractLiteralValue", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "isPossibleLooseOfPrecision", "", "targetType", "Lcom/intellij/psi/PsiType;", "actualType", "intellij.groovy.psi"})
@JvmName(name="PrecisionUtil")
public final class PrecisionUtil {
    public static final boolean isPossibleLooseOfPrecision(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrExpression expression) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        int targetRank = TypeConstants.getTypeRank(targetType);
        int actualRank = TypeConstants.getTypeRank(actualType);
        if (targetRank == 2 || actualRank == 2 || targetRank == 7) {
            return false;
        }
        if (actualRank == 0 || targetRank == 0 || actualRank <= targetRank) {
            return false;
        }
        Number number = PrecisionUtil.extractLiteralValue(expression);
        if (number == null) {
            return true;
        }
        Number value = number;
        switch (targetRank) {
            case 1: {
                byte byteVal = value.byteValue();
                Number number2 = value;
                if (number2 instanceof Short) {
                    bl = Intrinsics.areEqual((Object)byteVal, (Object)value) ^ true;
                    break;
                }
                if (number2 instanceof Integer) {
                    bl = Intrinsics.areEqual((Object)byteVal, (Object)value) ^ true;
                    break;
                }
                if (number2 instanceof Long) {
                    bl = Intrinsics.areEqual((Object)byteVal, (Object)value) ^ true;
                    break;
                }
                if (number2 instanceof Float) {
                    if (!Float.valueOf(byteVal).equals(value)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = Intrinsics.areEqual((Object)byteVal, (Object)value) ^ true;
                break;
            }
            case 3: {
                short shortVal = value.shortValue();
                Number number3 = value;
                if (number3 instanceof Integer) {
                    bl = Intrinsics.areEqual((Object)shortVal, (Object)value) ^ true;
                    break;
                }
                if (number3 instanceof Long) {
                    bl = Intrinsics.areEqual((Object)shortVal, (Object)value) ^ true;
                    break;
                }
                if (number3 instanceof Float) {
                    if (!Float.valueOf(shortVal).equals(value)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = Intrinsics.areEqual((Object)shortVal, (Object)value) ^ true;
                break;
            }
            case 4: {
                int intVal = value.intValue();
                Number number4 = value;
                if (number4 instanceof Long) {
                    bl = Intrinsics.areEqual((Object)intVal, (Object)value) ^ true;
                    break;
                }
                if (number4 instanceof Float) {
                    if (!Float.valueOf(intVal).equals(value)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = Intrinsics.areEqual((Object)intVal, (Object)value) ^ true;
                break;
            }
            case 5: {
                long longVal = value.longValue();
                Number number5 = value;
                if (number5 instanceof Float) {
                    if (!Float.valueOf(longVal).equals(value)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = Intrinsics.areEqual((Object)longVal, (Object)value) ^ true;
                break;
            }
            case 8: {
                float floatVal = value.floatValue();
                bl = Intrinsics.areEqual((Object)floatVal, (Object)value) ^ true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static final Number extractLiteralValue(GrExpression expression) {
        GrExpression grExpression;
        boolean negativeNumber = false;
        GrExpression valueExpression = expression;
        if (expression instanceof GrUnaryExpression) {
            IElementType iElementType = ((GrUnaryExpression)expression).getOperationTokenType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expression.operationTokenType");
            IElementType operationTokenType = iElementType;
            if (ArraysKt.contains((Object[])new IElementType[]{GroovyElementTypes.T_PLUS, GroovyElementTypes.T_MINUS}, (Object)operationTokenType)) {
                negativeNumber = Intrinsics.areEqual((Object)operationTokenType, (Object)GroovyElementTypes.T_MINUS);
                valueExpression = ((GrUnaryExpression)expression).getOperand();
            }
        }
        if (!((grExpression = valueExpression) instanceof GrLiteral)) {
            grExpression = null;
        }
        GrLiteral grLiteral = (GrLiteral)grExpression;
        Object object = grLiteral != null ? grLiteral.getValue() : null;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        if (number == null) {
            return null;
        }
        Number value = number;
        return negativeNumber ? (Number)PrecisionUtil.commonNegate(value) : (Number)value;
    }

    private static final Number commonNegate(Number num) {
        Number number;
        Number number2 = num;
        if (number2 instanceof Byte) {
            number = (int)(-num.byteValue());
        } else if (number2 instanceof Short) {
            number = (int)(-num.shortValue());
        } else if (number2 instanceof Integer) {
            number = -num.intValue();
        } else if (number2 instanceof Long) {
            number = -num.longValue();
        } else if (number2 instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)num;
            boolean bl = false;
            BigInteger bigInteger2 = bigInteger.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.negate()");
            number = bigInteger2;
        } else if (number2 instanceof Float) {
            number = Float.valueOf(-num.floatValue());
        } else if (number2 instanceof Double) {
            number = -num.doubleValue();
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)num;
            boolean bl = false;
            BigDecimal bigDecimal2 = bigDecimal.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.negate()");
            number = bigDecimal2;
        } else {
            number = null;
        }
        return number;
    }
}

