/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class GroovyFallthroughInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.fallthrough.in.switch.statement", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*thro?u");

        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
            if (switchStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(switchStatement);
            GrCaseSection[] caseSections = switchStatement.getCaseSections();
            for (int i = 1; i < caseSections.length; ++i) {
                GrCaseSection caseSection = caseSections[i];
                if (Visitor.isCommented(caseSection)) continue;
                GrCaseSection previousCaseSection = caseSections[i - 1];
                GrStatement[] statements2 = previousCaseSection.getStatements();
                if (statements2.length == 0) {
                    this.registerError(caseSection.getFirstChild());
                    continue;
                }
                GrStatement lastStatement = statements2[statements2.length - 1];
                if (!ControlFlowUtils.statementMayCompleteNormally(lastStatement)) continue;
                this.registerError(caseSection.getFirstChild());
            }
        }

        private static boolean isCommented(GrCaseSection caseClause) {
            PsiElement element = PsiUtilKt.skipWhiteSpacesAndNewLines(caseClause, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)PsiTreeUtil::prevLeaf));
            if (!(element instanceof PsiComment)) {
                return false;
            }
            String commentText = element.getText();
            return commentPattern.matcher(commentText).find();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyFallthroughInspection$Visitor", "visitSwitchStatement"));
        }
    }
}

