/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/IncDecUnaryTransformation;", "Lorg/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation;", "operator", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "apply", "", "methodCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "options", "Lorg/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$Options;", "couldApplyInternal", "", "needParentheses", "intellij.groovy.psi"})
public final class IncDecUnaryTransformation
extends Transformation {
    private final IElementType operator;

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options2) {
        Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return false;
    }

    @Override
    protected boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options2) {
        Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        GrExpression grExpression = Transformation.getBase(methodCall);
        if (grExpression == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"getBase(methodCall) ?: return false");
        GrExpression base = grExpression;
        if (!this.checkArgumentsCount(methodCall, 0)) {
            return false;
        }
        PsiElement psiElement = methodCall.getParent();
        if (!(psiElement instanceof GrAssignmentExpression)) {
            psiElement = null;
        }
        GrAssignmentExpression grAssignmentExpression = (GrAssignmentExpression)psiElement;
        if (grAssignmentExpression == null) {
            return false;
        }
        GrAssignmentExpression assignment = grAssignmentExpression;
        if (assignment.getRValue() != methodCall) {
            return false;
        }
        return EquivalenceChecker.expressionsAreEquivalent(assignment.getLValue(), base);
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options2) {
        Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        GrExpression grExpression = Transformation.getBase(methodCall);
        if (grExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"getBase(methodCall) ?: return");
        GrExpression base = grExpression;
        PsiElement psiElement = methodCall.getParent();
        if (!(psiElement instanceof GrAssignmentExpression)) {
            psiElement = null;
        }
        GrAssignmentExpression grAssignmentExpression = (GrAssignmentExpression)psiElement;
        if (grAssignmentExpression == null) {
            return;
        }
        GrAssignmentExpression parent2 = grAssignmentExpression;
        GrInspectionUtil.replaceExpression(parent2, this.operator + base.getText());
    }

    public IncDecUnaryTransformation(@NotNull IElementType operator) {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        this.operator = operator;
    }
}

