/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.SuppressByGroovyFileCommentFixKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u0014\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016J\r\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/SuppressByGroovyFileCommentFix;", "Lcom/intellij/codeInsight/daemon/impl/actions/SuppressByCommentFix;", "toolId", "", "(Ljava/lang/String;)V", "createSuppression", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "container", "getContainer", "context", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "intellij.groovy.psi"})
public final class SuppressByGroovyFileCommentFix
extends SuppressByCommentFix {
    @NotNull
    public String getText() {
        String string = AnalysisBundle.message((String)"suppress.inspection.file", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AnalysisBundle.message(\"suppress.inspection.file\")");
        return string;
    }

    @Nullable
    public PsiElement getContainer(@Nullable PsiElement context) {
        PsiElement psiElement = context;
        return (PsiElement)(psiElement != null ? psiElement.getContainingFile() : null);
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        GroovyFile file = (GroovyFile)container;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)file);
        if (document == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026tDocument(file) ?: return");
        Document document2 = document;
        String commentText = "//file:noinspection " + this.myID;
        PsiComment anchor = (PsiComment)SequencesKt.lastOrNull((Sequence)SuppressByGroovyFileCommentFixKt.access$fileComments(file));
        if (anchor == null) {
            document2.insertString(0, (CharSequence)(commentText + '\n'));
        } else {
            TextRange textRange = anchor.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"anchor.textRange");
            document2.insertString(textRange.getEndOffset(), (CharSequence)('\n' + commentText));
        }
    }

    public SuppressByGroovyFileCommentFix(@NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        super(toolId, GroovyFile.class);
    }
}

