/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.bundled;

import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/bundled/BundledGroovyResolveScopeProvider;", "Lcom/intellij/psi/ResolveScopeEnlarger;", "()V", "getAdditionalResolveScope", "Lcom/intellij/psi/search/SearchScope;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.groovy"})
public final class BundledGroovyResolveScopeProvider
extends ResolveScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (index.getModuleForFile(file) != null) {
            return null;
        }
        VirtualFile virtualFile = VfsUtil.getRootFile((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsUtil.getRootFile(file)");
        VirtualFile rootFile = virtualFile;
        if (Intrinsics.areEqual((Object)rootFile, (Object)BundledGroovy.getBundledGroovyJarRoot())) {
            GlobalSearchScope globalSearchScope = BundledGroovy.createBundledGroovyScope(project);
            if (globalSearchScope == null) {
                return null;
            }
            GlobalSearchScope scope = globalSearchScope;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            Sdk sdk = projectRootManager.getProjectSdk();
            if (sdk == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"ProjectRootManager.getIn\u2026projectSdk ?: return null");
            Sdk sdk2 = sdk;
            JdkScope jdkScope = new JdkScope(project, sdk2.getRootProvider().getFiles(OrderRootType.CLASSES), sdk2.getRootProvider().getFiles(OrderRootType.SOURCES), sdk2.getName());
            return (SearchScope)scope.uniteWith((GlobalSearchScope)jdkScope);
        }
        return null;
    }
}

