/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.ConvertLambdaToClosureAction;
import org.jetbrains.plugins.groovy.annotator.intentions.ReplaceDotFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.GrDoWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionList;
import org.jetbrains.plugins.groovy.lang.psi.api.GrInExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrTryResourceList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnAmbiguousClosureContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020AH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre30;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkAmbiguousCodeBlockInDefinition", "", "typeDefinitionBody", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinitionBody;", "error", "typeArgumentList", "Lcom/intellij/psi/PsiElement;", "msg", "", "followsError", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "isClosureAmbiguous", "mayBeAnonymousBody", "visitArrayInitializer", "arrayInitializer", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrArrayInitializer;", "visitAssignmentExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrAssignmentExpression;", "visitBinaryExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "visitBlockStatement", "blockStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrBlockStatement;", "visitClosure", "visitCodeReferenceElement", "refElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "visitDoWhileStatement", "statement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrDoWhileStatement;", "visitExpressionList", "expressionList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrExpressionList;", "visitInExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrInExpression;", "visitIndexProperty", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "visitInstanceofExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrInstanceOfExpression;", "visitLambdaExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "visitModifierList", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "visitReferenceExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "visitTryResourceList", "resourceList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrTryResourceList;", "visitTupleAssignmentExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrTupleAssignmentExpression;", "visitTypeDefinitionBody", "visitTypeElement", "typeElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeElement;", "visitVariableDeclaration", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "intellij.groovy.psi"})
public final class GroovyAnnotatorPre30
extends GroovyElementVisitor {
    private final AnnotationHolder holder;

    private final void error(PsiElement typeArgumentList, @InspectionMessage String msg) {
        this.holder.newAnnotation(HighlightSeverity.ERROR, msg).range(typeArgumentList).create();
    }

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        Intrinsics.checkNotNullParameter((Object)modifierList, (String)"modifierList");
        PsiElement psiElement = modifierList.getModifier("default");
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"modifierList.getModifier\u2026difier.DEFAULT) ?: return");
        PsiElement modifier = psiElement;
        String string = GroovyBundle.message("default.modifier.in.old.versions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"default.modifier.in.old.versions\")");
        this.error(modifier, string);
    }

    @Override
    public void visitDoWhileStatement(@NotNull GrDoWhileStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        super.visitDoWhileStatement(statement);
        PsiElement psiElement = statement.getDoKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"statement.doKeyword");
        String string = GroovyBundle.message("unsupported.do.while.statement", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.do.while.statement\")");
        this.error(psiElement, string);
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        GrExpression initializer;
        Intrinsics.checkNotNullParameter((Object)variableDeclaration, (String)"variableDeclaration");
        super.visitVariableDeclaration(variableDeclaration);
        if (variableDeclaration.getParent() instanceof GrTraditionalForClause) {
            if (variableDeclaration.isTuple()) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.tuple.declaration.in.for", new Object[0])).create();
            } else if (variableDeclaration.getVariables().length > 1) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.multiple.variables.in.for", new Object[0])).create();
            }
        } else if (variableDeclaration.isTuple() && (initializer = variableDeclaration.getTupleInitializer()) != null && PsiUtilKt.isApplicationExpression(initializer)) {
            PsiElement psiElement = initializer;
            String string = GroovyBundle.message("unsupported.tuple.application.initializer", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.tup\u2026application.initializer\")");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitExpressionList(@NotNull GrExpressionList expressionList) {
        Intrinsics.checkNotNullParameter((Object)expressionList, (String)"expressionList");
        super.visitExpressionList(expressionList);
        if (expressionList.getExpressions().size() > 1) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.expression.list.in.for.update", new Object[0])).create();
        }
    }

    @Override
    public void visitTryResourceList(@NotNull GrTryResourceList resourceList) {
        Intrinsics.checkNotNullParameter((Object)resourceList, (String)"resourceList");
        super.visitTryResourceList(resourceList);
        PsiElement psiElement = resourceList.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"resourceList.firstChild");
        String string = GroovyBundle.message("unsupported.resource.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.resource.list\")");
        this.error(psiElement, string);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        PsiElement psiElement = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.operationToken");
        PsiElement operator = psiElement;
        ASTNode aSTNode = operator.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"operator.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"operator.node.elementType");
        IElementType tokenType = iElementType;
        if (tokenType == GroovyElementTypes.T_ID || tokenType == GroovyElementTypes.T_NID) {
            String string = GroovyBundle.message("operator.is.not.supported.in", tokenType);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"operator.is.not.supported.in\", tokenType)");
            this.error(operator, string);
        }
    }

    @Override
    public void visitInExpression(@NotNull GrInExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitInExpression(expression);
        if (GrInExpression.isNegated(expression)) {
            PsiElement psiElement = expression.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.operationToken");
            String string = GroovyBundle.message("unsupported.negated.in", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.negated.in\")");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitInstanceofExpression(expression);
        if (GrInstanceOfExpression.isNegated(expression)) {
            PsiElement psiElement = expression.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.operationToken");
            String string = GroovyBundle.message("unsupported.negated.instanceof", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.negated.instanceof\")");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitAssignmentExpression(expression);
        PsiElement psiElement = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.operationToken");
        PsiElement operator = psiElement;
        ASTNode aSTNode = operator.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"operator.node");
        if (aSTNode.getElementType() == GroovyElementTypes.T_ELVIS_ASSIGN) {
            String string = GroovyBundle.message("unsupported.elvis.assignment", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.elvis.assignment\")");
            this.error(operator, string);
        }
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIndexProperty(expression);
        PsiElement safeAccessToken = expression.getSafeAccessToken();
        if (safeAccessToken != null) {
            String string = GroovyBundle.message("unsupported.safe.index.access", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.safe.index.access\")");
            this.error(safeAccessToken, string);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitReferenceExpression(expression);
        PsiElement psiElement = expression.getDotToken();
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.dotToken ?: return");
        PsiElement dot = psiElement;
        ASTNode aSTNode = dot.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"dot.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"dot.node.elementType");
        IElementType tokenType = iElementType;
        if (tokenType == GroovyElementTypes.T_METHOD_REFERENCE) {
            IElementType iElementType2 = GroovyElementTypes.T_METHOD_CLOSURE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"T_METHOD_CLOSURE");
            ReplaceDotFix fix = new ReplaceDotFix(tokenType, iElementType2);
            String string = GroovyBundle.message("operator.is.not.supported.in", tokenType);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"operator.is.not.supported.in\", tokenType)");
            String message = string;
            ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)expression.getProject()).createProblemDescriptor(dot, dot, message, ProblemHighlightType.ERROR, true, new LocalQuickFix[0]);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"InspectionManager.getIns\u2026tType.ERROR, true\n      )");
            ProblemDescriptor descriptor = problemDescriptor;
            this.holder.newAnnotation(HighlightSeverity.ERROR, message).range(dot).newLocalQuickFix((LocalQuickFix)fix, descriptor).registerFix().create();
        }
    }

    @Override
    public void visitArrayInitializer(@NotNull GrArrayInitializer arrayInitializer) {
        Intrinsics.checkNotNullParameter((Object)arrayInitializer, (String)"arrayInitializer");
        super.visitArrayInitializer(arrayInitializer);
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.array.initializers", new Object[0])).create();
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitLambdaExpression(expression);
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.lambda", new Object[0])).range(expression.getArrow()).withFix((IntentionAction)new ConvertLambdaToClosureAction(expression)).create();
    }

    @Override
    public void visitTypeDefinitionBody(@NotNull GrTypeDefinitionBody typeDefinitionBody) {
        Intrinsics.checkNotNullParameter((Object)typeDefinitionBody, (String)"typeDefinitionBody");
        super.visitTypeDefinitionBody(typeDefinitionBody);
        this.checkAmbiguousCodeBlockInDefinition(typeDefinitionBody);
    }

    private final void checkAmbiguousCodeBlockInDefinition(GrTypeDefinitionBody typeDefinitionBody) {
        PsiElement psiElement = typeDefinitionBody.getParent();
        if (!(psiElement instanceof GrAnonymousClassDefinition)) {
            psiElement = null;
        }
        GrAnonymousClassDefinition grAnonymousClassDefinition = (GrAnonymousClassDefinition)psiElement;
        if (grAnonymousClassDefinition == null) {
            return;
        }
        GrAnonymousClassDefinition parent2 = grAnonymousClassDefinition;
        PsiElement prev = typeDefinitionBody.getPrevSibling();
        if (!PsiUtil.isLineFeed(prev)) {
            return;
        }
        PsiElement psiElement2 = parent2.getParent();
        if (!(psiElement2 instanceof GrNewExpression)) {
            psiElement2 = null;
        }
        GrNewExpression grNewExpression = (GrNewExpression)psiElement2;
        if (grNewExpression == null) {
            return;
        }
        GrNewExpression newExpression = grNewExpression;
        GrStatementOwner statementOwner = (GrStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrStatementOwner.class);
        GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrParenthesizedExpression.class);
        if (parenthesizedExpression != null && PsiTreeUtil.isAncestor((PsiElement)statementOwner, (PsiElement)parenthesizedExpression, (boolean)true)) {
            return;
        }
        GrArgumentList argumentList = (GrArgumentList)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrArgumentList.class);
        if (argumentList != null && !(argumentList instanceof GrCommandArgumentList) && PsiTreeUtil.isAncestor((PsiElement)statementOwner, (PsiElement)argumentList, (boolean)true)) {
            return;
        }
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
    }

    @Override
    public void visitBlockStatement(@NotNull GrBlockStatement blockStatement) {
        Intrinsics.checkNotNullParameter((Object)blockStatement, (String)"blockStatement");
        super.visitBlockStatement(blockStatement);
        if (blockStatement.getParent() instanceof GrStatementOwner) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        super.visitClosure(closure);
        if (!closure.hasParametersSection() && !this.followsError(closure) && this.isClosureAmbiguous(closure)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
        }
    }

    private final boolean followsError(GrClosableBlock closure) {
        PsiElement prev = closure.getPrevSibling();
        return prev instanceof PsiErrorElement || prev instanceof PsiWhiteSpace && prev.getPrevSibling() instanceof PsiErrorElement;
    }

    private final boolean isClosureAmbiguous(GrClosableBlock closure) {
        if (this.mayBeAnonymousBody(closure)) {
            return true;
        }
        PsiElement place = closure;
        PsiElement parent2;
        while ((parent2 = place.getParent()) != null && !(parent2 instanceof GrUnAmbiguousClosureContainer)) {
            if (PsiUtil.isExpressionStatement(place)) {
                return true;
            }
            if (parent2.getFirstChild() != place) {
                return false;
            }
            place = parent2;
        }
        return false;
    }

    private final boolean mayBeAnonymousBody(GrClosableBlock closure) {
        PsiElement psiElement = closure.getParent();
        if (!(psiElement instanceof GrMethodCallExpression)) {
            psiElement = null;
        }
        GrMethodCallExpression grMethodCallExpression = (GrMethodCallExpression)psiElement;
        if (grMethodCallExpression == null) {
            return false;
        }
        GrMethodCallExpression parent2 = grMethodCallExpression;
        if (!(parent2.getInvokedExpression() instanceof GrNewExpression)) {
            return false;
        }
        GrClosableBlock[] grClosableBlockArray = parent2.getClosureArguments();
        if (!ArrayUtil.contains((Object)closure, (Object[])Arrays.copyOf(grClosableBlockArray, grClosableBlockArray.length))) {
            return false;
        }
        for (PsiElement run = parent2.getParent(); run != null; run = run.getParent()) {
            if (run instanceof GrParenthesizedExpression) {
                return false;
            }
            if (!(run instanceof GrReturnStatement) && !(run instanceof GrAssertStatement) && !(run instanceof GrThrowStatement) && !(run instanceof GrCommandArgumentList)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitTypeElement(@NotNull GrTypeElement typeElement) {
        Intrinsics.checkNotNullParameter((Object)typeElement, (String)"typeElement");
        GrAnnotation[] grAnnotationArray = typeElement.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)grAnnotationArray, (String)"typeElement.annotations");
        GrAnnotation[] $this$forEach$iv = grAnnotationArray;
        boolean $i$f$forEach = false;
        GrAnnotation[] grAnnotationArray2 = $this$forEach$iv;
        int n = grAnnotationArray2.length;
        for (int i = 0; i < n; ++i) {
            GrAnnotation element$iv;
            GrAnnotation it = element$iv = grAnnotationArray2[i];
            boolean bl = false;
            GrAnnotation grAnnotation = it;
            Intrinsics.checkNotNullExpressionValue((Object)grAnnotation, (String)"it");
            PsiElement psiElement = grAnnotation;
            String string = GroovyBundle.message("unsupported.type.annotations", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.type.annotations\")");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        Intrinsics.checkNotNullParameter((Object)refElement, (String)"refElement");
        GrAnnotation[] grAnnotationArray = refElement.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)grAnnotationArray, (String)"refElement.annotations");
        GrAnnotation[] $this$forEach$iv = grAnnotationArray;
        boolean $i$f$forEach = false;
        GrAnnotation[] grAnnotationArray2 = $this$forEach$iv;
        int n = grAnnotationArray2.length;
        for (int i = 0; i < n; ++i) {
            GrAnnotation element$iv;
            GrAnnotation it = element$iv = grAnnotationArray2[i];
            boolean bl = false;
            GrAnnotation grAnnotation = it;
            Intrinsics.checkNotNullExpressionValue((Object)grAnnotation, (String)"it");
            PsiElement psiElement = grAnnotation;
            String string = GroovyBundle.message("unsupported.type.annotations", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.type.annotations\")");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        GrExpression rValue = expression.getRValue();
        if (rValue != null && PsiUtilKt.isApplicationExpression(rValue)) {
            PsiElement psiElement = rValue;
            String string = GroovyBundle.message("unsupported.tuple.application.initializer", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unsupported.tup\u2026application.initializer\")");
            this.error(psiElement, string);
        }
    }

    public GroovyAnnotatorPre30(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }
}

