/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps.reference;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepImpl;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepHelper;

public class CucumberStepReference
implements PsiPolyVariantReference {
    private static final MyResolver RESOLVER = new MyResolver();
    private final PsiElement myStep;
    private final TextRange myRange;

    public CucumberStepReference(PsiElement step, TextRange range) {
        this.myStep = step;
        this.myRange = range;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myStep;
        if (psiElement == null) {
            CucumberStepReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            CucumberStepReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public PsiElement resolve() {
        ResolveResult[] result = this.multiResolve(true);
        return result.length == 1 ? result[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myStep.getText();
        if (string == null) {
            CucumberStepReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            CucumberStepReference.$$$reportNull$$$0(3);
        }
        return this.myStep;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CucumberStepReference.$$$reportNull$$$0(4);
        }
        return this.myStep;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        ResolveResult[] resolvedResults;
        if (element == null) {
            CucumberStepReference.$$$reportNull$$$0(5);
        }
        for (ResolveResult rr : resolvedResults = this.multiResolve(false)) {
            if (!this.getElement().getManager().areElementsEquivalent(rr.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        Project project = this.getElement().getProject();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)project).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, false, incompleteCode);
        if (resolveResultArray == null) {
            CucumberStepReference.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    private ResolveResult[] multiResolveInner() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myStep);
        if (module == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        List frameworks = CucumberJvmExtensionPoint.EP_NAME.getExtensionList();
        Collection stepVariants = frameworks.stream().map(e -> e.getStepName(this.myStep)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (stepVariants.size() == 0) {
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiFile featureFile = this.myStep.getContainingFile();
        List stepDefinitions = (List)CachedValuesManager.getCachedValue((PsiElement)featureFile, () -> {
            ArrayList<AbstractStepDefinition> allStepDefinition = new ArrayList<AbstractStepDefinition>();
            for (CucumberJvmExtensionPoint e : frameworks) {
                allStepDefinition.addAll(CucumberUtil.loadFrameworkSteps(e, featureFile, module));
            }
            return CachedValueProvider.Result.create(allStepDefinition, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        block0: for (AbstractStepDefinition stepDefinition : stepDefinitions) {
            if (!stepDefinition.supportsStep(this.myStep)) continue;
            for (String stepVariant : stepVariants) {
                PsiElement element = stepDefinition.getElement();
                if (!stepDefinition.matches(stepVariant) || element == null || resolvedElements.contains(element)) continue;
                resolvedElements.add(element);
                continue block0;
            }
        }
        return (ResolveResult[])resolvedElements.stream().map(PsiElementResolveResult::new).toArray(ResolveResult[]::new);
    }

    @Nullable
    public AbstractStepDefinition resolveToDefinition() {
        Collection<AbstractStepDefinition> definitions = this.resolveToDefinitions();
        return definitions.isEmpty() ? null : definitions.iterator().next();
    }

    @NotNull
    public Collection<AbstractStepDefinition> resolveToDefinitions() {
        Collection<AbstractStepDefinition> collection = CucumberStepHelper.findStepDefinitions(this.myStep.getContainingFile(), (GherkinStepImpl)this.myStep);
        if (collection == null) {
            CucumberStepReference.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantResolver<CucumberStepReference> {
        private MyResolver() {
        }

        public ResolveResult @NotNull [] resolve(@NotNull CucumberStepReference ref, boolean incompleteCode) {
            if (ref == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            ResolveResult[] resolveResultArray = ref.multiResolveInner();
            if (resolveResultArray == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference$MyResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference$MyResolver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

