/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.actions;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class GherkinStepParameterSelectioner
extends AbstractWordSelectioner {
    private static final Set<Pair<String, String>> START_END = new LinkedHashSet<Pair<String, String>>();

    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(0);
        }
        return e.getParent() instanceof GherkinStep || e.getParent() instanceof GherkinStepsHolder;
    }

    @NotNull
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement parent;
        if (e == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        if (editor.getSettings().isCamelWords()) {
            result.addAll(super.select(e, editorText, cursorOffset, editor));
        }
        if ((parent = e.getParent()) instanceof GherkinStep) {
            GherkinStep step = (GherkinStep)parent;
            for (PsiReference reference : step.getReferences()) {
                List<TextRange> ranges;
                AbstractStepDefinition definition;
                if (!(reference instanceof CucumberStepReference) || DumbService.isDumb((Project)step.getProject()) || (definition = ((CucumberStepReference)reference).resolveToDefinition()) == null || (ranges = GherkinPsiUtil.buildParameterRanges(step, definition, step.getTextOffset() + reference.getRangeInElement().getStartOffset())) == null) continue;
                result.addAll(ranges);
                result.addAll(GherkinStepParameterSelectioner.buildAdditionalRanges(ranges, editorText));
            }
            GherkinStepParameterSelectioner.buildAdditionalRanges(result, editorText);
        } else if (parent instanceof GherkinStepsHolder) {
            ASTNode keyword;
            ASTNode stepHolderNode = parent.getNode();
            if (stepHolderNode != null && (keyword = stepHolderNode.findChildByType(GherkinTokenTypes.KEYWORDS)) != null) {
                result.add(TextRange.create((int)keyword.getTextRange().getStartOffset(), (int)parent.getTextRange().getEndOffset()));
            }
            result.add(parent.getTextRange());
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static List<TextRange> buildAdditionalRanges(@NotNull List<TextRange> ranges, @NotNull CharSequence editorText) {
        if (ranges == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(5);
        }
        if (editorText == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(6);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        for (TextRange textRange : ranges) {
            if (textRange.isEmpty()) continue;
            GherkinStepParameterSelectioner.addRangesForText(result, textRange, editorText);
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void addRangesForText(@NotNull List<TextRange> result, @NotNull TextRange textRange, @NotNull CharSequence charSequence) {
        if (result == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(8);
        }
        if (textRange == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(9);
        }
        if (charSequence == null) {
            GherkinStepParameterSelectioner.$$$reportNull$$$0(10);
        }
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        String text = charSequence.subSequence(startOffset, endOffset).toString();
        for (Pair<String, String> startEnd : START_END) {
            TextRange newRange;
            String textWithEdges;
            TextRange newRange2;
            String start = (String)startEnd.first;
            String end = (String)startEnd.second;
            if (text.startsWith(start) && text.endsWith(end) && !(newRange2 = TextRange.create((int)(startOffset + start.length()), (int)(endOffset - end.length()))).isEmpty()) {
                result.add(newRange2);
                GherkinStepParameterSelectioner.addRangesForText(result, newRange2, charSequence);
            }
            int startOffsetWithEdge = startOffset - start.length();
            int endOffsetWithEdge = endOffset + end.length();
            if (startOffsetWithEdge < 0 || endOffsetWithEdge > charSequence.length() || !(textWithEdges = charSequence.subSequence(startOffsetWithEdge, endOffsetWithEdge).toString()).startsWith(start) || !textWithEdges.endsWith(end) || (newRange = TextRange.create((int)startOffsetWithEdge, (int)endOffsetWithEdge)).isEmpty()) continue;
            result.add(newRange);
        }
    }

    static {
        START_END.add((Pair<String, String>)Pair.create((Object)"'", (Object)"'"));
        START_END.add((Pair<String, String>)Pair.create((Object)"\"", (Object)"\""));
        START_END.add((Pair<String, String>)Pair.create((Object)"<", (Object)">"));
        START_END.add((Pair<String, String>)Pair.create((Object)"(", (Object)")"));
        START_END.add((Pair<String, String>)Pair.create((Object)"[", (Object)"]"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAdditionalRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildAdditionalRanges";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRangesForText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

