/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.js;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.messaging.model.SpringMessagingModel;
import com.intellij.spring.messaging.model.SpringMessagingType;
import com.intellij.spring.model.utils.AntPathMatcher;
import com.intellij.spring.websocket.js.SpringMessagingReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringMessagingReferenceProvider
extends PsiReferenceProvider {
    private final SpringMessagingType @NotNull [] myMessagingTypes;

    SpringMessagingReferenceProvider(SpringMessagingType ... types) {
        if (types == null) {
            SpringMessagingReferenceProvider.$$$reportNull$$$0(0);
        }
        this.myMessagingTypes = types;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        SpringMessagingModel model;
        if (element == null) {
            SpringMessagingReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SpringMessagingReferenceProvider.$$$reportNull$$$0(2);
        }
        if ((model = SpringMessagingReferenceProvider.getModel(element)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringMessagingReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String url = StringUtil.unquoteString((String)element.getText());
        List variants = ContainerUtil.filter((Collection)model.getUrls(this.myMessagingTypes), variant -> {
            if (variant.isPattern) {
                return AntPathMatcher.match((String)variant.lookupString, (String)url);
            }
            return variant.presentation.equals(url);
        });
        if (variants.isEmpty()) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new SpringMessagingReference(element, this.myMessagingTypes)};
            if (psiReferenceArray == null) {
                SpringMessagingReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        SpringMessagingReference[] springMessagingReferenceArray = SpringMessagingReference.createReferences(element, variants, this.myMessagingTypes);
        if (springMessagingReferenceArray == null) {
            SpringMessagingReferenceProvider.$$$reportNull$$$0(5);
        }
        return springMessagingReferenceArray;
    }

    @Nullable
    private static SpringMessagingModel getModel(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            SpringMessagingReferenceProvider.$$$reportNull$$$0(6);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null ? null : new SpringMessagingModel(module, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/websocket/js/SpringMessagingReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/websocket/js/SpringMessagingReferenceProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

