/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.js;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.messaging.model.SpringMessagingModel;
import com.intellij.spring.messaging.model.SpringMessagingType;
import com.intellij.spring.messaging.model.UrlPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringMessagingReference
extends PsiReferenceBase.Poly<PsiElement> {
    @NotNull
    private final List<SpringMessagingModel.Variant> myVariants;
    private final int myPartIndex;
    private final SpringMessagingType @NotNull [] myMessagingTypes;

    SpringMessagingReference(@NotNull PsiElement element, SpringMessagingType @NotNull [] messagingTypes) {
        if (element == null) {
            SpringMessagingReference.$$$reportNull$$$0(0);
        }
        if (messagingTypes == null) {
            SpringMessagingReference.$$$reportNull$$$0(1);
        }
        super(element, true);
        this.myVariants = Collections.emptyList();
        this.myPartIndex = -1;
        this.myMessagingTypes = messagingTypes;
    }

    private SpringMessagingReference(@NotNull PsiElement element, @NotNull List<SpringMessagingModel.Variant> variants, int partIndex, @NotNull TextRange textRange, SpringMessagingType @NotNull [] messagingTypes) {
        if (element == null) {
            SpringMessagingReference.$$$reportNull$$$0(2);
        }
        if (variants == null) {
            SpringMessagingReference.$$$reportNull$$$0(3);
        }
        if (textRange == null) {
            SpringMessagingReference.$$$reportNull$$$0(4);
        }
        if (messagingTypes == null) {
            SpringMessagingReference.$$$reportNull$$$0(5);
        }
        super(element, textRange, variants.get((int)0).parts[partIndex].getPsiElement() == null);
        this.myVariants = variants;
        this.myMessagingTypes = messagingTypes;
        this.myPartIndex = partIndex;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (this.myVariants.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringMessagingReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List elements = ContainerUtil.mapNotNull(this.myVariants, variant -> {
            UrlPointer pointer = variant.parts[this.myPartIndex];
            return pointer == null ? null : pointer.getPsiElement();
        });
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)elements);
        if (resolveResultArray == null) {
            SpringMessagingReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    @Nullable
    private SpringMessagingModel getModel() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        return module == null ? null : new SpringMessagingModel(module, this.getElement());
    }

    public Object @NotNull [] getVariants() {
        SpringMessagingModel model = this.getModel();
        if (model == null) {
            if (EMPTY_ARRAY == null) {
                SpringMessagingReference.$$$reportNull$$$0(8);
            }
            return EMPTY_ARRAY;
        }
        Object[] objectArray = ContainerUtil.map2Array((Collection)model.getUrls(this.myMessagingTypes), LookupElement.class, variant -> {
            PsiElement resolveElement = variant.urlDefinition.getPsiElement();
            if (resolveElement != null) {
                return LookupElementBuilder.create((Object)resolveElement, (String)variant.presentation).withTypeText(FileUtilRt.getNameWithoutExtension((String)resolveElement.getContainingFile().getName()));
            }
            return LookupElementBuilder.create((String)variant.presentation);
        });
        if (objectArray == null) {
            SpringMessagingReference.$$$reportNull$$$0(9);
        }
        return objectArray;
    }

    public static SpringMessagingReference[] createReferences(@NotNull PsiElement element, @NotNull List<SpringMessagingModel.Variant> variants, SpringMessagingType @NotNull [] messagingTypes) {
        String classPrefixUrl;
        int startOffset;
        if (element == null) {
            SpringMessagingReference.$$$reportNull$$$0(10);
        }
        if (variants == null) {
            SpringMessagingReference.$$$reportNull$$$0(11);
        }
        if (messagingTypes == null) {
            SpringMessagingReference.$$$reportNull$$$0(12);
        }
        String elementText = element.getText();
        SpringMessagingModel.Variant variant = variants.get(0);
        String appPrefixUrl = variant.appPrefix.getUrl();
        if (elementText.indexOf(appPrefixUrl, 1) != 1) {
            return new SpringMessagingReference[]{new SpringMessagingReference(element, messagingTypes)};
        }
        ArrayList<SpringMessagingReference> result = new ArrayList<SpringMessagingReference>();
        int previousPartEndIndex = appPrefixUrl.length() + 1;
        result.add(new SpringMessagingReference(element, variants, 0, new TextRange(1, previousPartEndIndex), messagingTypes));
        if (variant.classPrefix != null && (startOffset = elementText.indexOf(classPrefixUrl = variant.classPrefix.getUrl(), previousPartEndIndex)) >= 0) {
            previousPartEndIndex = startOffset + classPrefixUrl.length();
            result.add(new SpringMessagingReference(element, variants, 1, new TextRange(startOffset, previousPartEndIndex), messagingTypes));
        }
        result.add(new SpringMessagingReference(element, variants, 2, new TextRange(1, elementText.length() - 1), messagingTypes));
        return result.toArray(new SpringMessagingReference[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagingTypes";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/websocket/js/SpringMessagingReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/websocket/js/SpringMessagingReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

