/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CssNonIntegerLengthInPixelsInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssNonIntegerLengthInPixelsInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            public void visitCssTerm(CssTerm _term) {
                PsiElement numberTerm;
                super.visitCssTerm(_term);
                PsiElement[] children = _term.getChildren();
                if (children.length == 1 && (numberTerm = children[0]) != null && numberTerm.getNode().getElementType() == CssElementTypes.CSS_NUMBER_TERM) {
                    PsiElement unit;
                    if (CssNonIntegerLengthInPixelsInspection.mayBeColorStopValue(numberTerm)) {
                        return;
                    }
                    PsiElement number = numberTerm.getFirstChild();
                    if (number != null && (unit = numberTerm.getLastChild()) != null && "px".equals(unit.getText())) {
                        try {
                            Integer.parseInt(number.getText());
                        }
                        catch (NumberFormatException e) {
                            holder.registerProblem(number, CssBundle.message((String)"invalid.css.integer.value.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{CssFixFactory.getInstance().roundPxValueQuickFix()});
                        }
                    }
                }
            }
        };
    }

    private static boolean mayBeColorStopValue(PsiElement psiElement) {
        CssFunction function = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, CssFunction.class);
        return function != null && function.getName().contains("gradient");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/bugs/CssNonIntegerLengthInPixelsInspection", "buildVisitor"));
    }
}

