/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyValueImpl
extends CssTableValueBase<CssPropertyValue, Object>
implements CssPropertyValue {
    private String myRefName;
    private boolean myComplete = true;

    public CssPropertyValueImpl(CssTableValue.Type type) {
        super(type);
    }

    public CssPropertyValueImpl(@NonNls Object v) {
        super(v);
    }

    public boolean isComplete() {
        return this.myComplete;
    }

    public void setComplete(boolean complete) {
        this.myComplete = complete;
    }

    @Nullable
    public String getRefName() {
        return this.myRefName;
    }

    public void setRefName(@NotNull String refName) {
        if (refName == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(0);
        }
        this.myRefName = refName;
    }

    public int getMaxCompletionContextLength() {
        return this.computeValuesCount(true);
    }

    public int getMaxValuesCount() {
        return this.computeValuesCount(false);
    }

    private int computeValuesCount(boolean completedOnly) {
        if (!completedOnly || this.isComplete()) {
            if (this.isGroup()) {
                CssTableValue.Type type = this.getType();
                int result = 0;
                if (CssTableValue.Type.ANY == type || CssTableValue.Type.DEFAULT == type) {
                    for (CssPropertyValue each : this.getChildren()) {
                        if (result >= Integer.MAX_VALUE) continue;
                        int inc = each.isGroup() ? ((CssPropertyValueImpl)each).computeValuesCount(completedOnly) : 1;
                        result = inc < Integer.MAX_VALUE ? result + inc : Integer.MAX_VALUE;
                    }
                    return result;
                }
                for (CssPropertyValue each : this.getChildren()) {
                    int childLength = each.isGroup() ? ((CssPropertyValueImpl)each).computeValuesCount(completedOnly) : 1;
                    result = Math.max(result, childLength);
                }
                int maxCount = this.getMaxCount();
                int minCount = this.getMinCount();
                if (minCount == -1 && maxCount == -1) {
                    return result;
                }
                if (maxCount == -1) {
                    return Integer.MAX_VALUE;
                }
                return result * maxCount;
            }
            int maxCount = this.getMaxCount();
            int minCount = this.getMinCount();
            if (-1 == minCount && -1 == maxCount) {
                return 1;
            }
            if (-1 == maxCount) {
                return Integer.MAX_VALUE;
            }
            return maxCount;
        }
        return 0;
    }

    public int getCompletionCount(@NotNull CssCompletionContext context) {
        if (context == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        assert (!context.isEmpty());
        if (this.isGroup()) {
            CssTableValue.Type type = this.getType();
            int completionCount = 0;
            for (CssPropertyValue each : this.getChildren()) {
                int childCompletionCount;
                int n = childCompletionCount = each.isCompleted(context) ? each.getCompletionCount(context) : 0;
                if (CssTableValue.Type.ANY == type || CssTableValue.Type.DEFAULT == type || CssTableValue.Type.FULL_ANY == type) {
                    if (context.getLength() < this.getMaxCompletionContextLength()) continue;
                    completionCount += childCompletionCount;
                    continue;
                }
                int minCount = this.getMinCount();
                int maxCount = this.getMaxCount();
                if (-1 == minCount && -1 == maxCount) {
                    completionCount = Math.max(completionCount, childCompletionCount);
                    continue;
                }
                if (maxCount == -1) {
                    return 0;
                }
                completionCount += childCompletionCount;
            }
            return completionCount;
        }
        if (context.isCurrent()) {
            return 0;
        }
        int count = 0;
        for (CssCompletionContext c = context; c != null; c = c.getParent()) {
            count += this.isValueBelongs(c.getElement()) ? 1 : 0;
        }
        return count;
    }

    public boolean isCompleted(@NotNull CssCompletionContext context) {
        if (context == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        if (context.isEmpty()) {
            return false;
        }
        return !this.isComplete() || this.getCompletionCount(context) >= this.getMaxCompletionContextLength();
    }

    @Nullable
    protected CssTermType getPrefixTermType() {
        String prefix = this.getPrefix();
        if (prefix != null && "$number$".equals(prefix)) {
            return CssTermTypes.NUMBER;
        }
        return null;
    }

    private boolean matchesContext(@NotNull CssCompletionContext context) {
        if (context == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(3);
        }
        return context.matchesTermType(this.getPrefixTermType());
    }

    @NotNull
    protected List<? extends CssPropertyValue> createVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(4);
        }
        if (context.isEmpty()) {
            List<Object> list = this.isGroup() ? this.getChildren() : this.createValueList();
            if (list == null) {
                CssPropertyValueImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (this.isGroup()) {
            switch (this.getType()) {
                case ANY: {
                    return this.createAnyVariants(context, contextElement);
                }
                case FULL_ANY: {
                    return this.createAnyVariants(context, contextElement);
                }
                case DEFAULT: {
                    return this.createDefaultVariants(context, contextElement);
                }
            }
            return this.createOrVariants(context, contextElement);
        }
        List<CssPropertyValue> list = this.createValueList();
        if (list == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<CssPropertyValue> createAnyVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(7);
        }
        int maxCount = this.getChildren().size();
        int completionCount = this.getCompletionCount(context);
        if (completionCount < maxCount) {
            List<CssPropertyValue> result = this.checkVariants(context, contextElement);
            if (result.isEmpty()) {
                for (CssPropertyValue each : this.getChildren()) {
                    if (each.isCompleted(context)) continue;
                    result.add(each);
                }
            }
            if (result.isEmpty()) {
                result.addAll(this.getChildren());
            }
            List<CssPropertyValue> list = result;
            if (list == null) {
                CssPropertyValueImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<CssPropertyValue> list = Collections.emptyList();
        if (list == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private List<CssPropertyValue> createDefaultVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(10);
        }
        int maxCount = -1 == this.getMinCount() ? 1 : this.getMaxCount();
        int completionCount = this.getCompletionCount(context);
        if (completionCount < maxCount) {
            ArrayList<CssPropertyValue> result = new ArrayList<CssPropertyValue>();
            for (CssPropertyValue each : this.getChildren()) {
                if (each.isCompleted(context)) continue;
                result.addAll(each.getVariants(context, contextElement));
                break;
            }
            if (result.isEmpty()) {
                result.addAll(this.getChildren());
            }
            ArrayList<CssPropertyValue> arrayList = result;
            if (arrayList == null) {
                CssPropertyValueImpl.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        List<CssPropertyValue> list = Collections.emptyList();
        if (list == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private List<CssPropertyValue> createOrVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        if (context == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(13);
        }
        int maxCount = this.getMinCount() == -1 ? 1 : (this.getMaxCount() == -1 ? 1 : this.getMaxCount());
        int completionCount = this.getCompletionCount(context);
        if (completionCount < maxCount) {
            List<CssPropertyValue> result = this.checkVariants(context, contextElement);
            if (result.isEmpty()) {
                List<CssPropertyValue> list = this.createValueList();
                if (list == null) {
                    CssPropertyValueImpl.$$$reportNull$$$0(14);
                }
                return list;
            }
            List<CssPropertyValue> list = result;
            if (list == null) {
                CssPropertyValueImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<CssPropertyValue> list = Collections.emptyList();
        if (list == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    private List<CssPropertyValue> checkVariants(CssCompletionContext context, PsiElement contextElement) {
        ArrayList<CssPropertyValue> result = new ArrayList<CssPropertyValue>();
        for (CssPropertyValue each : this.getChildren()) {
            if (each.isCompleted(context) || !context.isCurrent() && !each.isValueBelongs(context.getElement())) continue;
            result.addAll(each.getVariants(context, contextElement));
        }
        return result;
    }

    public boolean isValueBelongs(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (this.isGroup()) {
            boolean belongs = false;
            for (CssPropertyValue each : this.getChildren()) {
                belongs |= each.isValueBelongs(element);
            }
            return belongs;
        }
        Object value = this.getValue();
        if (value instanceof String) {
            return ((String)value).equalsIgnoreCase(element.getText());
        }
        return false;
    }

    private List<CssPropertyValue> createValueList() {
        return new ArrayList<CssPropertyValue>(Collections.singletonList(this));
    }

    @NotNull
    public List<? extends CssPropertyValue> getVariants(@NotNull CssCompletionContext context, PsiElement contextElement) {
        List<? extends CssPropertyValue> dynamicVariants;
        if (context == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(17);
        }
        if (!(dynamicVariants = this.getDynamicVariants(contextElement)).isEmpty()) {
            List<? extends CssPropertyValue> list = dynamicVariants;
            if (list == null) {
                CssPropertyValueImpl.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (this.matchesContext(context) && !this.isCompleted(context)) {
            List<? extends CssPropertyValue> list = this.createVariants(context, contextElement);
            if (list == null) {
                CssPropertyValueImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public List<? extends CssPropertyValue> getDynamicVariants(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(21);
        }
        List list = Collections.emptyList();
        if (list == null) {
            CssPropertyValueImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssPropertyValueImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariants";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnyVariants";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultVariants";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrVariants";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRefName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionCount";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCompleted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVariants";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAnyVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultVariants";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createOrVariants";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

