/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.CssLanguageProperties;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.MinifiedFilesUtil;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMinifiedFileChecker {
    private static final TokenSet NO_WS_REQUIRE_AFTER_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_RBRACE, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_COLON});

    public static boolean isMinifiedFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CssMinifiedFileChecker.$$$reportNull$$$0(0);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> CachedValueProvider.Result.create((Object)CssMinifiedFileChecker.isMinifiedFileStatic(psiFile), (Object[])new Object[]{psiFile}));
    }

    private static boolean isMinifiedFileStatic(@NotNull PsiFile psiFile) {
        boolean indentBased;
        VirtualFile file;
        if (psiFile == null) {
            CssMinifiedFileChecker.$$$reportNull$$$0(1);
        }
        if ((file = psiFile.getVirtualFile()) == null) {
            return false;
        }
        Language language = CssMinifiedFileChecker.suggestLanguageByFileName(file.getName());
        if (language == null || !language.isKindOf((Language)CSSLanguage.INSTANCE)) {
            return false;
        }
        if (file.getName().contains(".min.")) {
            return true;
        }
        if (file.getName().contains(".dev.")) {
            return false;
        }
        boolean bl = indentBased = language instanceof CssLanguageProperties && ((CssLanguageProperties)language).isIndentBased();
        if (indentBased) {
            return false;
        }
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        return MinifiedFilesUtil.isMinified((CharSequence)LoadTextUtil.loadText((VirtualFile)file), (ParserDefinition)def, (TokenSet)NO_WS_REQUIRE_AFTER_TOKEN_SET, (TokenSet)NO_WS_REQUIRE_AFTER_TOKEN_SET);
    }

    @Nullable
    private static Language suggestLanguageByFileName(@NotNull String fileName) {
        FileType fileType;
        if (fileName == null) {
            CssMinifiedFileChecker.$$$reportNull$$$0(2);
        }
        if (!((fileType = FileTypeRegistry.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)fileName))) instanceof LanguageFileType)) {
            return null;
        }
        return ((LanguageFileType)fileType).getLanguage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/CssMinifiedFileChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMinifiedFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMinifiedFileStatic";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestLanguageByFileName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

