/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import cucumber.api.HookTestStep;
import cucumber.api.PickleStepTestStep;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.TestStepFinished;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleLocation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatterUtil;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStepFinishedEvent;

public class CucumberJvm3Adapter {
    private static PickleEvent getPickleEvent(TestCase testCase) {
        try {
            Field pickleEventField = testCase.getClass().getDeclaredField("pickleEvent");
            pickleEventField.setAccessible(true);
            return (PickleEvent)pickleEventField.get(testCase);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class CucumberJvmTestStep
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStep {
        private final TestStep myRealStep;

        public CucumberJvmTestStep(TestStep realStep) {
            this.myRealStep = realStep;
        }

        public String getLocation() {
            if (this.myRealStep instanceof HookTestStep) {
                try {
                    Field definitionMatchField = this.myRealStep.getClass().getSuperclass().getDeclaredField("stepDefinitionMatch");
                    definitionMatchField.setAccessible(true);
                    Object definitionMatchFieldValue = definitionMatchField.get(this.myRealStep);
                    Field hookDefinitionField = definitionMatchFieldValue.getClass().getDeclaredField("hookDefinition");
                    hookDefinitionField.setAccessible(true);
                    Object hookDefinitionFieldValue = hookDefinitionField.get(definitionMatchFieldValue);
                    Field methodField = hookDefinitionFieldValue.getClass().getDeclaredField("method");
                    methodField.setAccessible(true);
                    Object methodFieldValue = methodField.get(hookDefinitionFieldValue);
                    if (methodFieldValue instanceof Method) {
                        Method method = (Method)methodFieldValue;
                        return String.format("java:test://%s/%s", method.getDeclaringClass().getName(), method.getName());
                    }
                }
                catch (Exception definitionMatchField) {
                    // empty catch block
                }
                return "";
            }
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)this.myRealStep;
            return "file://" + pickleStepTestStep.getStepLocation() + ":" + pickleStepTestStep.getStepLine();
        }

        public String getStepName() {
            String stepName = this.myRealStep instanceof HookTestStep ? "Hook: " + ((HookTestStep)this.myRealStep).getHookType().toString() : this.getStepKeyword() + " " + ((PickleStepTestStep)this.myRealStep).getPickleStep().getText();
            return stepName;
        }

        private String getStepKeyword() {
            try {
                PickleStepTestStep pickleStep = (PickleStepTestStep)this.myRealStep;
                String location = pickleStep.getStepLocation();
                if (location.startsWith("file://")) {
                    location = location.substring("file://".length());
                } else if (location.startsWith("file:")) {
                    location = location.substring("file:".length());
                }
                int lastColonIndex = location.lastIndexOf(58);
                String filePath = location.substring(0, lastColonIndex);
                String lineNumberString = location.substring(lastColonIndex + 1);
                String result = CucumberJvmSMFormatterUtil.getStepKeyword((String)filePath, (int)Integer.parseInt(lineNumberString));
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return "Given";
        }
    }

    public static class CucumberJvmTestCase
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestCase {
        private final TestCase myRealTestCase;

        CucumberJvmTestCase(TestCase realTestCase) {
            this.myRealTestCase = realTestCase;
        }

        public boolean isScenarioOutline() {
            PickleEvent pickleEvent = CucumberJvm3Adapter.getPickleEvent(this.myRealTestCase);
            return pickleEvent != null && pickleEvent.pickle.getLocations().size() > 1;
        }

        public String getUri() {
            return this.myRealTestCase.getUri();
        }

        public int getScenarioOutlineLine() {
            PickleEvent pickleEvent = CucumberJvm3Adapter.getPickleEvent(this.myRealTestCase);
            if (pickleEvent != null) {
                return ((PickleLocation)pickleEvent.pickle.getLocations().get(pickleEvent.pickle.getLocations().size() - 1)).getLine();
            }
            return 0;
        }

        public int getLine() {
            return this.myRealTestCase.getLine();
        }

        public String getScenarioName() {
            return this.myRealTestCase.getName();
        }
    }

    public static class CucumberJvmTestStepFinishedEvent
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStepFinishedEvent {
        private final CucumberJvmTestStep myTestStep;
        private final TestStepFinished myRealEvent;

        public CucumberJvmTestStepFinishedEvent(TestStepFinished testStepFinished) {
            this.myTestStep = new CucumberJvmTestStep(testStepFinished.testStep);
            this.myRealEvent = testStepFinished;
        }

        public org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStep getTestStep() {
            return this.myTestStep;
        }

        public CucumberJvmTestStepFinishedEvent.Status getResult() {
            switch (this.myRealEvent.result.getStatus()) {
                case PASSED: {
                    return CucumberJvmTestStepFinishedEvent.Status.PASSED;
                }
                case PENDING: {
                    return CucumberJvmTestStepFinishedEvent.Status.PENDING;
                }
                case SKIPPED: {
                    return CucumberJvmTestStepFinishedEvent.Status.SKIPPED;
                }
            }
            return CucumberJvmTestStepFinishedEvent.Status.FAILED;
        }

        public Long getDuration() {
            return this.myRealEvent.result.getDuration() != null ? this.myRealEvent.result.getDuration() / 1000000L : 0L;
        }

        public String getErrorMessage() {
            return this.myRealEvent.result.getErrorMessage();
        }
    }
}

