/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.versions.DeprecatedLibInfo;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DeprecatedMavenDependencyInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "kotlin.maven"})
public final class DeprecatedMavenDependencyInspection
extends DomElementsInspection<MavenDomProjectModel>
implements CleanupLocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        if (domFileElement == null || holder == null) {
            return;
        }
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"domFileElement.file");
        XmlFile file = xmlFile;
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"domFileElement.module ?: return");
        Module module2 = module;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module2);
        if (mavenProject == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"manager.findProject(module) ?: return");
        MavenProject mavenProject2 = mavenProject;
        PomFile pomFile = PomFile.Companion.forFileOrNull(file);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        for (DeprecatedLibInfo libInfo : KotlinRuntimeLibraryUtilKt.getDEPRECATED_LIBRARIES_INFORMATION()) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv;
            MavenId libMavenId = new MavenId(libInfo.getOld().getGroupId(), libInfo.getOld().getName(), null);
            Iterable iterable = PomFile.findDependencies$default(pomFile2, libMavenId, null, 2, null);
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                void $this$mapTo$iv$iv;
                MavenDomDependency it = (MavenDomDependency)element$iv$iv;
                boolean bl = false;
                List list = mavenProject2.findDependencies(libInfo.getOld().getGroupId(), libInfo.getOld().getName());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mavenProject.findDepende\u2026roupId, libInfo.old.name)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    MavenArtifact mavenArtifact = (MavenArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    void v6 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
                    String string = v6.getVersion();
                    collection.add(string);
                }
                String libVersion = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)));
                if (!(libVersion != null && VersionComparatorUtil.COMPARATOR.compare(libVersion, libInfo.getOutdatedAfterVersion()) >= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List moduleDependencies = (List)destination$iv$iv;
            MavenDomDependencyManagement mavenDomDependencyManagement = pomFile2.getDomModel().getDependencyManagement();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencyManagement, (String)"pomFile.domModel.dependencyManagement");
            MavenDomDependencies mavenDomDependencies = mavenDomDependencyManagement.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"pomFile.domModel.dependencyManagement.dependencies");
            Iterable $this$filter$iv2 = PomFileKt.findDependencies$default(mavenDomDependencies, libMavenId, null, 2, null);
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MavenDomDependency it = (MavenDomDependency)element$iv$iv;
                boolean bl = false;
                GenericDomValue genericDomValue = it.getVersion();
                String version = genericDomValue != null ? genericDomValue.getStringValue() : null;
                if (!(version != null && VersionComparatorUtil.COMPARATOR.compare(version, libInfo.getOutdatedAfterVersion()) >= 0)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List dependencyManagementDependencies = (List)destination$iv$iv3;
            for (MavenDomDependency dependency : CollectionsKt.plus((Collection)moduleDependencies, (Iterable)dependencyManagementDependencies)) {
                GenericDomValue genericDomValue = dependency.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"dependency.artifactId");
                XmlElement xmlElement = genericDomValue.getXmlElement();
                if (xmlElement == null) continue;
                ReplaceStringInDocumentFix fix = new ReplaceStringInDocumentFix((PsiElement)xmlElement, libInfo.getOld().getName(), libInfo.getNew().getName());
                holder.createProblem((DomElement)dependency.getArtifactId(), ProblemHighlightType.LIKE_DEPRECATED, libInfo.getMessage(), null, new LocalQuickFix[]{(LocalQuickFix)fix});
            }
        }
    }

    public DeprecatedMavenDependencyInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }
}

