/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.undo;

import com.intellij.diagram.DiagramActionsListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.project.Project;
import com.intellij.uml.undo.UmlUndoableAction;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlUndoProvider
implements UndoProvider,
DiagramActionsListener {
    @Nullable
    private final Project myProject;
    private volatile boolean myIsInsideCommand;

    public UmlUndoProvider(@Nullable Project project) {
        this.myProject = project;
        MessageBus bus = project == null ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
        bus.connect().subscribe(DiagramActionsListener.TOPIC, (Object)this);
    }

    public void commandStarted(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = true;
    }

    public void commandFinished(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = false;
    }

    private boolean shouldProcess() {
        return this.myProject != null && !this.myProject.isDisposed() && this.myIsInsideCommand;
    }

    @Override
    public void actionPerformed(@NotNull DiagramActionsListener.DiagramActionEvent event) {
        if (event == null) {
            UmlUndoProvider.$$$reportNull$$$0(0);
        }
        if (this.shouldProcess() && event.getBuilder().getDocumentReference() != null && UmlUndoProvider.isUndoable(CommandProcessor.getInstance().getCurrentCommandName())) {
            this.getUndoManager().undoableActionPerformed((UndoableAction)new UmlUndoableAction(event.getBuilder(), event.getOldState(), event.getFiles()));
        }
    }

    private static boolean isUndoable(@Nullable @NonNls String commandName) {
        return commandName != null && !GraphBuilderEvent.ZOOM_CHANGED.toString().equals(commandName) && !GraphBuilderEvent.GRAPH_MOVED.toString().equals(commandName);
    }

    @NotNull
    private UndoManager getUndoManager() {
        UndoManager undoManager = this.myProject != null ? UndoManager.getInstance((Project)this.myProject) : UndoManager.getGlobalInstance();
        if (undoManager == null) {
            UmlUndoProvider.$$$reportNull$$$0(1);
        }
        return undoManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/undo/UmlUndoProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/undo/UmlUndoProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

