/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.utils;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlPsiUtil {
    private static final String ID = "UML";

    private UmlPsiUtil() {
    }

    public static void runWriteActionInCommandProcessor(Project project, DocumentReference ref, @Nls String name, Runnable run) {
        Runnable cmd = () -> {
            if (ref != null) {
                UndoManager.getInstance((Project)project).nonundoableActionPerformed(ref, true);
            }
            ApplicationManager.getApplication().runWriteAction(run);
        };
        CommandProcessor.getInstance().executeCommand(project, cmd, name, (Object)ID, UndoConfirmationPolicy.DEFAULT, null);
    }

    public static void runWriteActionInCommandProcessor(Project project, PsiElement element, Runnable run) {
        UmlPsiUtil.runWriteActionInCommandProcessor(project, element, DiagramBundle.message("unknown.uml.action", new Object[0]), run);
    }

    public static void runWriteActionInCommandProcessor(Project project, PsiElement element, @Nls String name, Runnable run) {
        VirtualFile file;
        PsiFile psiFile = element.getContainingFile();
        DocumentReference ref = psiFile == null || (file = psiFile.getVirtualFile()) == null ? null : DocumentReferenceManager.getInstance().create(file);
        UmlPsiUtil.runWriteActionInCommandProcessor(project, ref, name, run);
    }

    @Nullable
    @Nls
    public static String createInheritanceBetween(PsiClass child, PsiClass parent) throws IncorrectOperationException {
        if (child.isInheritor(parent, true) || parent.isInheritor(child, true)) {
            return DiagramBundle.message("relationship.already.exists", child.getName(), parent.getName());
        }
        if (child.equals(parent)) {
            return null;
        }
        PsiModifierList modifiers = parent.getModifierList();
        if (modifiers == null) {
            return null;
        }
        if (child.isAnnotationType() && !parent.isAnnotationType()) {
            return DiagramBundle.message("annotation.class.cant.be.extended.or.implemented", new Object[0]);
        }
        if (modifiers.hasModifierProperty("final")) {
            return DiagramBundle.message("final.class.cant.be.inherited", parent.getName());
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)child.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        if (parent.isInterface()) {
            PsiReferenceList implementsList;
            PsiJavaCodeReferenceElement ref = factory.createClassReferenceElement(parent);
            PsiReferenceList psiReferenceList = implementsList = child.isInterface() ? child.getExtendsList() : child.getImplementsList();
            if (implementsList != null) {
                implementsList.add((PsiElement)ref);
            }
        } else {
            if (child.isInterface()) {
                return DiagramBundle.message("node.is.interface", new Object[0]);
            }
            PsiClass superClass = child.getSuperClass();
            if (superClass != null) {
                PsiJavaCodeReferenceElement ref = factory.createClassReferenceElement(parent);
                PsiReferenceList extendsList = child.getExtendsList();
                if (extendsList != null) {
                    if (extendsList.getReferenceElements().length > 0) {
                        extendsList.getReferenceElements()[0].replace((PsiElement)ref);
                    } else {
                        extendsList.add((PsiElement)ref);
                    }
                }
            } else if (facade.findClass("java.lang.Object", GlobalSearchScope.allScope((Project)child.getProject())) == null) {
                return DiagramBundle.message("set.up.jdk", new Object[0]);
            }
        }
        return null;
    }

    public static void makeClassAbstract(PsiClass child) {
        UmlPsiUtil.runWriteActionInCommandProcessor(child.getProject(), (PsiElement)child, DiagramBundle.message("make.class.abstract", new Object[0]), () -> {
            try {
                PsiModifierList modifierList = child.getModifierList();
                if (modifierList != null) {
                    modifierList.setModifierProperty("abstract", true);
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        });
    }

    public static boolean isAbstract(PsiClass child) {
        PsiModifierList modifierList = child.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("abstract");
    }

    @Nullable
    @Nls
    public static String annotateClass(PsiClass psiClass, PsiClass anno) {
        if (psiClass == null || anno == null) {
            return null;
        }
        assert (anno.isAnnotationType());
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return null;
        }
        String fqn = anno.getQualifiedName();
        if (fqn == null || modifierList.hasAnnotation(fqn)) {
            return null;
        }
        return UmlPsiUtil.addAnnotation(psiClass, fqn) ? null : DiagramBundle.message("cant.annotate.class.0", psiClass.getQualifiedName());
    }

    @Nullable
    public static PsiClass findAnnotationClass(PsiAnnotation annotation) {
        return annotation == null ? null : annotation.resolveAnnotationType();
    }

    @NotNull
    public static List<PsiClass> getAnnotationClassesForClass(@NotNull PsiClass psiClass) {
        PsiModifierList modifierList;
        if (psiClass == null) {
            UmlPsiUtil.$$$reportNull$$$0(0);
        }
        List list = (modifierList = psiClass.getModifierList()) != null ? ContainerUtil.mapNotNull((Object[])modifierList.getAnnotations(), UmlPsiUtil::findAnnotationClass) : List.of();
        if (list == null) {
            UmlPsiUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<PsiClass> getTypeParametersForClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            UmlPsiUtil.$$$reportNull$$$0(2);
        }
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        for (PsiTypeParameter parameter : psiClass.getTypeParameters()) {
            for (PsiClassType extClassType : parameter.getExtendsList().getReferencedTypes()) {
                PsiClass extClass = extClassType.resolve();
                if (extClass == null) continue;
                classes.add(extClass);
            }
        }
        ArrayList<PsiClass> arrayList = classes;
        if (arrayList == null) {
            UmlPsiUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public static Set<PsiClass> findAnnotationsForClass(PsiClass psiClass) {
        HashSet<PsiClass> classes = new HashSet<PsiClass>();
        if (psiClass == null) {
            return classes;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return classes;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            PsiClass aClass = UmlPsiUtil.findAnnotationClass(annotation);
            if (aClass == null) continue;
            classes.add(aClass);
        }
        return classes;
    }

    public static boolean addAnnotation(PsiClass psiElement, String fqn) {
        boolean[] result = new boolean[]{false};
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                PsiModifierList modifierList = psiElement.getModifierList();
                if (modifierList == null || !FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
                    return;
                }
                Project project = psiElement.getProject();
                PsiAnnotation psiAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@" + fqn, (PsiElement)psiElement);
                PsiElement element = modifierList.getFirstChild();
                if (element != null) {
                    modifierList.addBefore((PsiElement)psiAnnotation, element);
                } else {
                    modifierList.add((PsiElement)psiAnnotation);
                }
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
                result[0] = true;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        });
        return result[0];
    }

    public static Collection<PsiClass> getAllInnerClasses(PsiClass psiClass) {
        HashSet<PsiClass> inners = new HashSet<PsiClass>();
        for (PsiClass inner : psiClass.getInnerClasses()) {
            if (inner.getName() == null) continue;
            inners.add(inner);
            inners.addAll(UmlPsiUtil.getAllInnerClasses(inner));
        }
        return inners;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/utils/UmlPsiUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/utils/UmlPsiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationClassesForClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParametersForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationClassesForClass";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParametersForClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

