/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.providers;

import com.intellij.diagram.extras.providers.SupersProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassParents
extends SupersProvider<PsiElement> {
    @NotNull
    private static final Set<String> CLASSES_TO_EXCLUDE_FROM_LIST = ContainerUtil.set((Object[])new String[]{"java.lang.Object", "java.lang.Enum", "java.lang.constant.Constable"});

    @NotNull
    public static Set<PsiClass> getSupers(@Nullable PsiClass child) {
        HashSet<PsiClass> supers = new HashSet<PsiClass>();
        if (child == null) {
            HashSet<PsiClass> hashSet = supers;
            if (hashSet == null) {
                PsiClassParents.$$$reportNull$$$0(0);
            }
            return hashSet;
        }
        for (PsiClass psiClass : child.getSupers()) {
            supers.add(psiClass);
            supers.addAll(PsiClassParents.getSupers(psiClass));
        }
        supers.removeIf(it -> CLASSES_TO_EXCLUDE_FROM_LIST.contains(it.getQualifiedName()));
        HashSet<PsiClass> hashSet = supers;
        if (hashSet == null) {
            PsiClassParents.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public PsiClass @NotNull [] getElements(PsiElement element, @NotNull Project project) {
        if (project == null) {
            PsiClassParents.$$$reportNull$$$0(2);
        }
        PsiClass[] psiClassArray = element instanceof PsiClass ? PsiClassParents.getSupers((PsiClass)element).toArray(PsiClass.EMPTY_ARRAY) : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            PsiClassParents.$$$reportNull$$$0(3);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public String getHeaderName(PsiElement element, @NotNull Project project) {
        if (project == null) {
            PsiClassParents.$$$reportNull$$$0(4);
        }
        String string = DiagramBundle.message("show.supers.for", element instanceof PsiClass ? ((PsiClass)element).getName() : "");
        if (string == null) {
            PsiClassParents.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public Comparator<PsiElement> getComparator() {
        Comparator comparator = PSI_COMPARATOR;
        if (comparator == null) {
            PsiClassParents.$$$reportNull$$$0(6);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/providers/PsiClassParents";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/providers/PsiClassParents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

