/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.dependency;

import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uml.java.JavaUmlRelationships;
import com.intellij.uml.java.dependency.DependenciesConfiguration;
import com.intellij.uml.java.dependency.RelationshipAnalysisSimpleResult;
import com.intellij.uml.java.dependency.RelationshipAnalyzer;
import com.intellij.uml.java.utils.LightElementFacade;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public final class UastClassDependencyAnalyzer
implements RelationshipAnalyzer<PsiClass, RelationshipAnalysisSimpleResult<PsiClass>> {
    @Override
    @NotNull
    public Collection<RelationshipAnalysisSimpleResult<PsiClass>> compute(@NotNull PsiClass source) {
        if (source == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(0);
        }
        DependenciesConfiguration conf = DependenciesConfiguration.fromUmlConfiguration(DiagramConfiguration.getInstance());
        PsiElement initial = UastClassDependencyAnalyzer.getPhysicalElement(source);
        MyDependencyCollectingVisitor uastVisitor = new MyDependencyCollectingVisitor(source, conf);
        initial.accept(uastVisitor.asPsiVisitor());
        List<RelationshipAnalysisSimpleResult<PsiClass>> list = uastVisitor.getCollectedDependencies();
        if (list == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static PsiElement getPhysicalElement(@NotNull PsiClass psiClass) {
        PsiElement anchor;
        if (psiClass == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(2);
        }
        Object object = (anchor = LightElementFacade.asSourcePsi((PsiElement)psiClass)) != null ? anchor : psiClass;
        if (object == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(3);
        }
        return object;
    }

    @Nullable
    private static PsiClass typeToClass(@NotNull PsiType psiType) {
        PsiClass psiClass;
        PsiType unwrapped;
        if (psiType == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(4);
        }
        if ((unwrapped = psiType.getDeepComponentType()) instanceof PsiClassType && (psiClass = ((PsiClassType)unwrapped).resolve()) != null) {
            return psiClass;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "typeToClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyTypeRecursiveVisitor
    extends PsiTypeVisitor<Object> {
        @NotNull
        private final BiConsumer<PsiClass, Boolean> myCallback;
        private boolean myIsInsideCollection;
        @NotNull
        private static final Set<String> OUR_COLLECTIONS = ContainerUtil.immutableSet((Object[])new String[]{"java.lang.Iterable", "java.util.Map", "java.util.Dictionary", "kotlin.collections.Iterable", "kotlin.collections.Map", "com.google.common.collect.Multimap", "com.google.common.collect.RangeMap", "com.google.common.collect.RangeSet", "com.google.common.collect.Table"});

        private MyTypeRecursiveVisitor(@NotNull BiConsumer<PsiClass, Boolean> callback) {
            if (callback == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(0);
            }
            this.myCallback = callback;
        }

        public Object visitType(@NotNull PsiType type) {
            PsiClass psiClass;
            if (type == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(1);
            }
            if ((psiClass = UastClassDependencyAnalyzer.typeToClass(type)) instanceof PsiTypeParameter) {
                return null;
            }
            if (psiClass != null) {
                this.myCallback.accept(psiClass, this.myIsInsideCollection);
            }
            if (!this.myIsInsideCollection && MyTypeRecursiveVisitor.isCollection(type)) {
                this.myIsInsideCollection = true;
                this.visitSubComponentsRecursively(type);
                this.myIsInsideCollection = false;
            }
            return null;
        }

        private void visitSubComponentsRecursively(@NotNull PsiType type) {
            if (type == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(2);
            }
            if (type instanceof PsiClassType) {
                for (PsiType typeParameter : ((PsiClassType)type).getParameters()) {
                    typeParameter.accept((PsiTypeVisitor)this);
                }
            } else if (type instanceof PsiArrayType) {
                type.getDeepComponentType().accept((PsiTypeVisitor)this);
            }
        }

        private static boolean isCollection(@NotNull PsiType type) {
            if (type == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(3);
            }
            if (type instanceof PsiArrayType) {
                return true;
            }
            PsiClass aClass = UastClassDependencyAnalyzer.typeToClass(type);
            if (aClass == null) {
                return false;
            }
            List<PsiClass> classes = MyTypeRecursiveVisitor.getAllInterfaces(aClass);
            classes.add(aClass);
            for (PsiClass cl : classes) {
                String fqn = cl.getQualifiedName();
                if (fqn == null || !OUR_COLLECTIONS.contains(fqn)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        private static List<PsiClass> getAllInterfaces(@NotNull PsiClass psiClass) {
            PsiClass[] inters;
            if (psiClass == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(4);
            }
            ArrayList<PsiClass> interfaces = new ArrayList<PsiClass>();
            for (PsiClass inter : inters = psiClass.getInterfaces()) {
                interfaces.add(inter);
                interfaces.addAll(MyTypeRecursiveVisitor.getAllInterfaces(inter));
            }
            ArrayList<PsiClass> arrayList = interfaces;
            if (arrayList == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyTypeRecursiveVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyTypeRecursiveVisitor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllInterfaces";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSubComponentsRecursively";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isCollection";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllInterfaces";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyDependencyCollectingVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final List<RelationshipAnalysisSimpleResult<PsiClass>> myDependencies;
        @NotNull
        private final DependenciesConfiguration myConf;
        private static final Class<? extends UElement> @NotNull [] OUR_EXPECTED_UAST_TYPES = new Class[]{UField.class, UCallExpression.class, USimpleNameReferenceExpression.class, UTypeReferenceExpression.class};

        private MyDependencyCollectingVisitor(@NotNull PsiClass psiClass, @NotNull DependenciesConfiguration conf) {
            if (psiClass == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (conf == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(1);
            }
            this.myDependencies = new ArrayList<RelationshipAnalysisSimpleResult<PsiClass>>();
            this.myClass = psiClass;
            this.myConf = conf;
        }

        @NotNull
        public PsiElementVisitor asPsiVisitor() {
            return new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    UElement uElement;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])OUR_EXPECTED_UAST_TYPES)) != null) {
                        uElement.accept((UastVisitor)this);
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyDependencyCollectingVisitor$1", "visitElement"));
                }
            };
        }

        private boolean isInsideInnerClass(@NotNull UElement node) {
            UClass containingUClass;
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(2);
            }
            return (containingUClass = UastUtils.getContainingUClass((UElement)node)) != null && !Objects.equals(this.myClass.getQualifiedName(), containingUClass.getQualifiedName());
        }

        public boolean visitField(@NotNull UField node) {
            UTypeReferenceExpression typeReference;
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(3);
            }
            if ((typeReference = node.getTypeReference()) != null) {
                this.visitTypeReferenceExpression(typeReference);
            }
            return false;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(4);
            }
            if (this.isInsideInnerClass((UElement)node)) {
                return false;
            }
            UReferenceExpression constructingClassReference = node.getClassReference();
            if (constructingClassReference != null) {
                PsiElement resolved = constructingClassReference.resolve();
                PsiClass psiClass = MyDependencyCollectingVisitor.findConcreteClass(resolved instanceof PsiClass ? (PsiClass)resolved : null);
                if (psiClass != null) {
                    this.add(psiClass, JavaUmlRelationships.CREATE, MyDependencyCollectingVisitor.getNavigatable(node.getSourcePsi()));
                }
            } else {
                PsiClass psiClass;
                PsiMethod resolvedMethod = node.resolve();
                if (resolvedMethod != null && (psiClass = resolvedMethod.getContainingClass()) != null) {
                    this.add(psiClass, JavaUmlRelationships.DEPENDENCY, MyDependencyCollectingVisitor.getNavigatable(node.getSourcePsi()));
                }
            }
            return false;
        }

        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(5);
            }
            if (this.isInsideInnerClass((UElement)node)) {
                return false;
            }
            PsiElement psiElement = node.resolve();
            if (psiElement instanceof PsiClass) {
                this.add((PsiClass)psiElement, JavaUmlRelationships.DEPENDENCY, MyDependencyCollectingVisitor.getNavigatable(node.getSourcePsi()));
            }
            return false;
        }

        public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(6);
            }
            if (this.isInsideInnerClass((UElement)node)) {
                return false;
            }
            PsiType type = node.getType();
            type.accept((PsiTypeVisitor)new MyTypeRecursiveVisitor((psiClass, isInsideCollection) -> {
                UField field = (UField)UastUtils.getParentOfType((UElement)node, UField.class);
                if (field != null && !(type instanceof PsiArrayType)) {
                    this.add((PsiClass)psiClass, isInsideCollection != false ? JavaUmlRelationships.TO_MANY : JavaUmlRelationships.TO_ONE, MyDependencyCollectingVisitor.getNavigatable(field.getSourcePsi()));
                } else {
                    this.add((PsiClass)psiClass, JavaUmlRelationships.DEPENDENCY, MyDependencyCollectingVisitor.getNavigatable(node.getSourcePsi()));
                }
            }));
            return false;
        }

        @NotNull
        private List<RelationshipAnalysisSimpleResult<PsiClass>> getCollectedDependencies() {
            List<RelationshipAnalysisSimpleResult<PsiClass>> list = this.myDependencies;
            if (list == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(7);
            }
            return list;
        }

        private void add(@NotNull PsiClass target, @NotNull DiagramRelationshipInfo relationshipInfo, @Nullable PsiElement navigatableElement) {
            if (target == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(8);
            }
            if (relationshipInfo == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(9);
            }
            if (relationshipInfo == JavaUmlRelationships.TO_ONE && !this.myConf.myShowOneToOne || relationshipInfo == JavaUmlRelationships.TO_MANY && !this.myConf.myShowOneToMany || relationshipInfo == JavaUmlRelationships.DEPENDENCY && !this.myConf.myShowUsages || Objects.equals(this.myClass.getQualifiedName(), target.getQualifiedName()) && !this.myConf.myShowCyclic || relationshipInfo == JavaUmlRelationships.CREATE && !this.myConf.myShowNewExpressions) {
                return;
            }
            this.myDependencies.add(new RelationshipAnalysisSimpleResult<PsiClass>(target, relationshipInfo, navigatableElement));
        }

        @Nullable
        private static PsiElement getNavigatable(@Nullable PsiElement psiElement) {
            return psiElement instanceof Navigatable ? psiElement : null;
        }

        @Nullable
        private static PsiClass findConcreteClass(@Nullable PsiClass psiClass) {
            while (psiClass instanceof PsiAnonymousClass) {
                psiClass = PsiUtil.resolveClassInType((PsiType)((PsiAnonymousClass)psiClass).getBaseClassType());
            }
            return psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conf";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyDependencyCollectingVisitor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relationshipInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyDependencyCollectingVisitor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCollectedDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsideInnerClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitField";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCallExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSimpleNameReferenceExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTypeReferenceExpression";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

