/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewFieldDialog
extends DialogWrapper
implements Disposable {
    private JPanel contentPane;
    private JCheckBox myFinal;
    private JComboBox myVisibility;
    private JCheckBox myStatic;
    private JPanel myTypePanel;
    private JPanel myNamePanel;
    private JPanel myInitializerPanel;
    private JLabel myPreviewText;
    private JPanel myPreview;
    private final EditorTextField myName;
    private final EditorTextField myType;
    private final EditorTextField myInitializer;
    private final PsiClass myClass;
    private final PsiField myField;
    private final PsiTypeCodeFragment myTypeCodeFragment;
    private final PsiExpressionCodeFragment myInitializerCode;
    private Runnable myAction = null;
    private static final String[] MODIFIERS = new String[]{"private", "packageLocal", "protected", "public"};

    public CreateNewFieldDialog(PsiClass psiClass) throws IncorrectOperationException {
        super(psiClass.getProject(), true);
        this.myClass = psiClass;
        this.$$$setupUI$$$();
        Project project = this.myClass.getProject();
        this.setTitle(DiagramBundle.message("add.new.field.title", psiClass.getName()));
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewFieldDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        this.myField = factory.createFieldFromText("private String field = null;", (PsiElement)this.myClass);
        PsiDocumentManager dm = PsiDocumentManager.getInstance((Project)project);
        JavaCodeFragmentFactory codeFragmentFactory = JavaCodeFragmentFactory.getInstance((Project)project);
        this.myTypeCodeFragment = codeFragmentFactory.createTypeCodeFragment(this.myField.getTypeElement().getText(), (PsiElement)this.myField.getTypeElement(), true, 1);
        Document typeDoc = dm.getDocument((PsiFile)this.myTypeCodeFragment);
        this.myType = new EditorTextField(typeDoc, project, (FileType)JavaFileType.INSTANCE);
        this.myTypePanel.add((Component)this.myType);
        this.myName = new EditorTextField();
        this.myNamePanel.add((Component)this.myName);
        this.myInitializerCode = codeFragmentFactory.createExpressionCodeFragment(this.myField.getInitializer().getText(), (PsiElement)this.myField, this.myField.getType(), true);
        this.myInitializer = new EditorTextField(dm.getDocument((PsiFile)this.myInitializerCode), project, (FileType)JavaFileType.INSTANCE);
        this.myInitializerPanel.add((Component)this.myInitializer);
        this.init();
        this.myType.setText("");
        this.myInitializer.setText("");
        this.setSize(500, 200);
        this.myPreview.setBorder((Border)IdeBorderFactory.createTitledBorder((String)DiagramBundle.message("preview", new Object[0]), (boolean)false));
        if (psiClass.isInterface()) {
            this.myVisibility.setSelectedIndex(3);
            this.myVisibility.setEnabled(false);
            this.myStatic.setSelected(true);
            this.myStatic.setEnabled(false);
            this.myFinal.setSelected(true);
            this.myFinal.setEnabled(false);
        }
        DocumentListener docListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CreateNewFieldDialog.this.onChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/java/actions/CreateNewFieldDialog$2", "documentChanged"));
            }
        };
        this.myType.addDocumentListener(docListener);
        this.myName.addDocumentListener(docListener);
        this.myInitializer.addDocumentListener(docListener);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewFieldDialog.this.onChange();
            }
        };
        this.myVisibility.addActionListener(actionListener);
        this.myStatic.addActionListener(actionListener);
        this.myFinal.addActionListener(actionListener);
        this.myType.addDocumentListener(new DocumentListener(){
            PsiType oldType = null;

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    PsiType type = CreateNewFieldDialog.this.myTypeCodeFragment.getType();
                    if (!type.equals(this.oldType)) {
                        CreateNewFieldDialog.this.myInitializerCode.setExpectedType(type);
                        Document doc = PsiDocumentManager.getInstance((Project)CreateNewFieldDialog.this.myClass.getProject()).getDocument((PsiFile)CreateNewFieldDialog.this.myInitializerCode);
                        CreateNewFieldDialog.this.myInitializer.setNewDocumentAndFileType((FileType)JavaFileType.INSTANCE, doc);
                        this.oldType = type;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/uml/java/actions/CreateNewFieldDialog$4", "documentChanged"));
            }
        });
        this.setModal(true);
    }

    private void onChange() {
        StringBuilder expr = new StringBuilder();
        if (!this.myClass.isInterface()) {
            expr.append(this.getModifier()).append(" ");
        }
        expr.append(this.myType.getText().trim()).append(" ").append(this.myName.getText().trim());
        String init = this.myInitializer.getText().trim();
        if (init.length() > 0) {
            if (!init.startsWith("=")) {
                expr.append("=");
            }
            expr.append(init);
        }
        expr.append(";");
        @NlsSafe String text = expr.toString();
        this.myPreviewText.setText(text);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myType;
    }

    @Nullable
    protected String getHelpId() {
        return "reference.uml.add.new.field.dialog";
    }

    private void onOK() {
        String msg = this.checkForm();
        if (msg != null) {
            Messages.showErrorDialog((Project)this.myClass.getProject(), (String)msg, (String)DiagramJavaBundle.message("dialog.message.error", new Object[0]));
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        if (this.myClass.isInterface() && this.myInitializer.getText().trim().length() == 0) {
            Messages.showErrorDialog((Project)this.myClass.getProject(), (String)DiagramBundle.message("constant.in.interface.must.have.initializer", new Object[0]), (String)DiagramBundle.message("initializer.is.empty", new Object[0]));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myInitializer, true));
            return;
        }
        this.myAction = () -> {
            try {
                PsiField[] fields;
                this.myField.setName(this.myName.getText().trim());
                PsiTypeElement typeElement = this.myField.getTypeElement();
                typeElement.replace((PsiElement)factory.createTypeElement(this.myTypeCodeFragment.getType()));
                this.myField.setInitializer(this.myInitializerCode.getExpression());
                PsiModifierList modifierList = this.myField.getModifierList();
                modifierList.setModifierProperty("private", false);
                if (!this.myClass.isInterface()) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)this.myField, (String)MODIFIERS[this.myVisibility.getSelectedIndex()], (boolean)true);
                    if (this.myStatic.isSelected()) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)this.myField, (String)"static", (boolean)true);
                    }
                    if (this.myFinal.isSelected()) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)this.myField, (String)"final", (boolean)true);
                    }
                }
                this.myClass.addAfter((PsiElement)this.myField, (PsiElement)((fields = this.myClass.getFields()).length == 0 ? this.myClass.getLBrace() : fields[fields.length - 1]));
                CommandProcessor.getInstance().runUndoTransparentAction(() -> new OptimizeImportsProcessor((AbstractLayoutCodeProcessor)new ReformatCodeProcessor(this.myClass.getProject(), this.myClass.getContainingFile(), null, false)).run());
            }
            catch (Exception e1) {
                ApplicationUtil.showDialogAfterWriteAction(() -> Messages.showErrorDialog((Project)this.myClass.getProject(), (String)DiagramJavaBundle.message("dialog.message.expression.0.is.invalid", this.myPreviewText.getText()), (String)DiagramJavaBundle.message("dialog.message.error", new Object[0])));
            }
            Disposer.dispose((Disposable)this);
        };
    }

    private String getModifier() {
        Object modifier = MODIFIERS[this.myVisibility.getSelectedIndex()];
        if (((String)modifier).equals("packageLocal")) {
            modifier = "";
        }
        if (this.myStatic.isSelected()) {
            modifier = (String)modifier + " static";
        }
        if (this.myFinal.isSelected()) {
            modifier = (String)modifier + " final";
        }
        return modifier;
    }

    private void onCancel() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    protected void doOKAction() {
        this.onOK();
        this.close(0);
    }

    public void doCancelAction() {
        this.onCancel();
    }

    @Nullable
    @Nls
    private String checkForm() {
        if (this.myType.getText().trim().length() == 0) {
            return DiagramJavaBundle.message("create.new.field.empty.type", new Object[0]);
        }
        if (this.myName.getText().trim().length() == 0) {
            return DiagramJavaBundle.message("create.new.field.empty.name", new Object[0]);
        }
        return null;
    }

    public Runnable getCreateAction() {
        return this.myAction;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JPanel jPanel5;
        this.contentPane = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", CreateNewFieldDialog.class).getString("create.new.field.name"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", CreateNewFieldDialog.class).getString("create.new.field.type"));
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", CreateNewFieldDialog.class).getString("create.new.field.visibility"));
        jPanel6.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVisibility = jComboBox = new JComboBox();
        ((Component)jComboBox).setBackground(new Color(-1));
        Font font = this.$$$getFont$$$(null, 1, -1, jComboBox.getFont());
        if (font != null) {
            jComboBox.setFont(font);
        }
        ((Component)jComboBox).setForeground(new Color(-16777114));
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("private");
        defaultComboBoxModel.addElement("package-private");
        defaultComboBoxModel.addElement("protected");
        defaultComboBoxModel.addElement("public");
        jComboBox.setModel(defaultComboBoxModel);
        jPanel6.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myFinal = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", CreateNewFieldDialog.class).getString("create.new.field.make.final"));
        jPanel6.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStatic = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", CreateNewFieldDialog.class).getString("create.new.field.make.static"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/DiagramJavaBundle", CreateNewFieldDialog.class).getString("create.new.field.initializer"));
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypePanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(150, -1), null));
        this.myNamePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, new Dimension(100, -1), null));
        this.myInitializerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel2, new GridConstraints(1, 3, 1, 1, 0, 3, 3, 3, null, new Dimension(200, -1), null));
        this.myPreview = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(3, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        this.myPreviewText = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

