/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaUmlVfsResolver
implements DiagramVfsResolver<PsiElement> {
    @Override
    @Nullable
    public String getQualifiedName(@Nullable PsiElement element) {
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        if (element instanceof PsiClassOwner) {
            return ((PsiClassOwner)element).getVirtualFile().getCanonicalPath();
        }
        if (element instanceof PsiDirectory) {
            return ((PsiDirectory)element).getVirtualFile().getCanonicalPath();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement resolveElementByFQN(@NotNull String fqn, @NotNull Project project) {
        if (fqn == null) {
            JavaUmlVfsResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaUmlVfsResolver.$$$reportNull$$$0(1);
        }
        return (PsiElement)ReadAction.compute(() -> {
            if (Strings.containsAnyChar((String)fqn, (String)"/\\")) {
                return JavaUmlVfsResolver.resolveByPath(fqn, project);
            }
            PsiElement fromFqn = JavaUmlVfsResolver.resolveByFQN(fqn, project);
            return fromFqn != null ? fromFqn : JavaUmlVfsResolver.resolveByPath(fqn, project);
        });
    }

    @Override
    @Nullable
    public PsiElement resolveInitElementByFQN(@NotNull String fqn, @NotNull Project project) {
        if (fqn == null) {
            JavaUmlVfsResolver.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JavaUmlVfsResolver.$$$reportNull$$$0(3);
        }
        return StringUtil.isEmpty((String)fqn) ? null : this.resolveElementByFQN(fqn, project);
    }

    @Nullable
    private static PsiElement resolveByFQN(@NotNull String fqn, @NotNull Project project) {
        JavaPsiFacade facadeEx;
        PsiClass psiClass;
        if (fqn == null) {
            JavaUmlVfsResolver.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JavaUmlVfsResolver.$$$reportNull$$$0(5);
        }
        return (psiClass = (facadeEx = JavaPsiFacade.getInstance((Project)project)).findClass(fqn, GlobalSearchScope.allScope((Project)project))) == null ? facadeEx.findPackage(fqn) : psiClass;
    }

    @Nullable
    private static PsiElement resolveByPath(@NotNull String path, @NotNull Project project) {
        VirtualFile file;
        if (path == null) {
            JavaUmlVfsResolver.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JavaUmlVfsResolver.$$$reportNull$$$0(7);
        }
        if ((file = VirtualFileManager.getInstance().findFileByNioPath(Path.of(path, new String[0]))) == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile != null ? psiFile : PsiManager.getInstance((Project)project).findDirectory(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/java/JavaUmlVfsResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveElementByFQN";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveInitElementByFQN";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveByFQN";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveByPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

