/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.fs;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.uml.utils.DiagramBundle;
import java.io.File;
import java.util.Collections;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SaveDiagramAction
extends DiagramAction {
    @Override
    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        DiagramBuilder builder = SaveDiagramAction.getBuilder(e);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (project == null || builder == null || !(fileEditor instanceof DiagramFileEditor)) {
            return;
        }
        Object filename = "diagram.uml";
        VirtualFile baseDir = null;
        DiagramFileEditor editor = (DiagramFileEditor)fileEditor;
        VirtualFile vf = editor.getOriginalVirtualFile();
        if (vf.getFileSystem() instanceof LocalFileSystem) {
            filename = vf.getName();
            baseDir = vf.getParent();
        } else {
            String fqn;
            Object original = builder.getGraph().getDataProvider((Object)"ORIGINAL_ELEMENT").get((Object)"");
            DiagramProvider<?> provider = builder.getProvider();
            if (original != null) {
                fqn = provider.getExtras().suggestDiagramFileName(original);
                if (fqn == null && (fqn = provider.getVfsResolver().getQualifiedName(original)) != null && fqn.contains(".") && !fqn.endsWith(".")) {
                    fqn = fqn.substring(fqn.lastIndexOf(46) + 1);
                }
            } else {
                fqn = provider.getElementManager().getElementTitle(builder.getDataModel().getOriginalElement());
            }
            if (fqn != null) {
                filename = fqn + ".uml";
            }
        }
        VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(DiagramBundle.message("dialog.title.save.file", new Object[0]), DiagramBundle.message("dialog.description.save.uml.class.diagram.as.uml", new Object[0]), new String[]{"uml"}), project).save(baseDir == null ? project.getBaseDir() : baseDir, (String)filename);
        if (wrapper == null) {
            return;
        }
        Document xml = new Document(new Element("Diagram"));
        DiagramState state = (DiagramState)editor.getState(FileEditorStateLevel.FULL);
        state.write(xml.getRootElement());
        wrapper = SaveDiagramAction.getWrapperWithUmlExtension(wrapper);
        VirtualFile file = wrapper.getVirtualFile(true);
        if (file == null || !state.saveTo(file, project)) {
            Object msg = DiagramBundle.message("can.t.save.diagram.to.0", wrapper.getFile().getPath());
            if (file != null && ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(file)).hasReadonlyFiles()) {
                msg = (String)msg + " " + CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]) + ".";
            }
            Messages.showErrorDialog((Project)project, (String)msg, (String)CommonBundle.getErrorTitle());
        }
    }

    @NotNull
    public static VirtualFileWrapper getWrapperWithUmlExtension(@NotNull VirtualFileWrapper wrapper) {
        File file;
        if (wrapper == null) {
            SaveDiagramAction.$$$reportNull$$$0(1);
        }
        if ("uml".equalsIgnoreCase(FileUtilRt.getExtension((String)(file = wrapper.getFile()).getName()))) {
            VirtualFileWrapper virtualFileWrapper = wrapper;
            if (virtualFileWrapper == null) {
                SaveDiagramAction.$$$reportNull$$$0(2);
            }
            return virtualFileWrapper;
        }
        return new VirtualFileWrapper(new File(file.getPath() + ".uml"));
    }

    @Override
    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(3);
        }
        return e.getProject() != null && e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DiagramFileEditor;
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.name.save.diagram", new Object[0]);
        if (string == null) {
            SaveDiagramAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/fs/SaveDiagramAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/fs/SaveDiagramAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperWithUmlExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperWithUmlExtension";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

