/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uml.UmlIcons;
import com.intellij.uml.utils.DiagramBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlAddNoteAction
extends DiagramActionWithPreparation<String> {
    public UmlAddNoteAction() {
        super(DiagramBundle.message("add.note.action.title", new Object[0]), "", UmlIcons.AddNote);
    }

    @Override
    @Nullable
    @Nls
    public String prepare(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlAddNoteAction.$$$reportNull$$$0(0);
        }
        return Messages.showMultilineInputDialog((Project)e.getProject(), (String)DiagramBundle.message("dialog.message.note.text", new Object[0]), (String)DiagramBundle.message("dialog.title.add.a.note", new Object[0]), (String)"", (Icon)Messages.getQuestionIcon(), (InputValidator)new NonEmptyInputValidator());
    }

    @Override
    public void execute(@NotNull DiagramBuilder builder, @Nls String description, AnActionEvent e) {
        if (builder == null) {
            UmlAddNoteAction.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)description)) {
            return;
        }
        DiagramDataModel<?> model = builder.getDataModel();
        DiagramNode<?> selectedNode = builder.getNodeObject(GraphSelectionService.getInstance().getSingleSelectedNode(builder.getGraph()));
        assert (selectedNode != null);
        DiagramNoteNode note = model.addNote(selectedNode, description);
        if (note != null) {
            builder.update(false, false);
            Node noteNode = builder.getNode(note);
            NodeRealizer realizer = builder.getGraph().getRealizer(noteNode);
            NodeRealizer target = builder.getGraph().getRealizer(builder.getNode(note.getIdentifyingElement()));
            realizer.setCenterX(target.getCenterX());
            realizer.setY(target.getY() - realizer.getHeight() - 20.0);
            builder.update(true, false);
            builder.notifyOtherBuilders();
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            UmlAddNoteAction.$$$reportNull$$$0(2);
        }
        if ((builder = UmlAddNoteAction.getBuilder(e)) != null) {
            Graph2D graph = builder.getGraph();
            Node selectedNode = GraphSelectionService.getInstance().getSingleSelectedNode(graph);
            if (selectedNode != null) {
                DiagramNode<?> node = builder.getNodeObject(selectedNode);
                DiagramDataModel<?> model = builder.getDataModel();
                if (!(node instanceof DiagramNoteNode) && !model.getNotes().containsKey(node)) {
                    e.getPresentation().setEnabled(true);
                    return;
                }
            }
        }
        e.getPresentation().setEnabled(false);
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.name.add.note", new Object[0]);
        if (string == null) {
            UmlAddNoteAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/UmlAddNoteAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/UmlAddNoteAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

