/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.graph.layout.ComponentLayouter;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.circular.CircularLayouter;
import com.intellij.openapi.graph.layout.circular.SingleCycleLayouter;
import com.intellij.openapi.graph.layout.genealogy.FamilyTreeLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.IncrementalHierarchicLayouter;
import com.intellij.openapi.graph.layout.organic.OrganicLayouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.layout.orthogonal.CompactOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.DirectedOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.OrthogonalGroupLayouter;
import com.intellij.openapi.graph.layout.radial.RadialLayouter;
import com.intellij.openapi.graph.layout.random.RandomLayouter;
import com.intellij.openapi.graph.layout.router.ChannelEdgeRouter;
import com.intellij.openapi.graph.layout.router.OrganicEdgeRouter;
import com.intellij.openapi.graph.layout.seriesparallel.SeriesParallelLayouter;
import com.intellij.openapi.graph.layout.tree.ARTreeLayouter;
import com.intellij.openapi.graph.layout.tree.BalloonLayouter;
import com.intellij.openapi.graph.layout.tree.GenericTreeLayouter;
import com.intellij.openapi.graph.layout.tree.HVTreeLayouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uml.utils.DiagramBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DiagramLayout {
    CUSTOM,
    COMPACT_ORTHOGONAL,
    COMPONENT,
    DIRECTED_ORTHOGONAL,
    HIERARCHIC,
    HIERARCHIC_COMPACT,
    ORTHOGONAL_GROUPS,
    CHANNEL,
    SERIES_PARALLEL,
    CIRCULAR,
    CIRCULAR_EDGE_BUNDLED,
    RADIAL,
    RADIAL_EDGE_BUNDLED,
    SINGLE_CYCLE,
    AR_TREE,
    BALLOON,
    BALLOON_EDGE_BUNDLED,
    FAMILY_TREE,
    GENERIC_TREE,
    HV_TREE,
    RANDOM,
    ORGANIC,
    ORGANIC_EDGE_BUNDLED;


    @NotNull
    public static DiagramLayout getDefault() {
        DiagramLayout diagramLayout = HIERARCHIC;
        if (diagramLayout == null) {
            DiagramLayout.$$$reportNull$$$0(0);
        }
        return diagramLayout;
    }

    @NotNull
    public static DiagramLayout getCurrentLayout(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramLayout.$$$reportNull$$$0(1);
        }
        GraphSettings graphSettings = builder.getPresentationModel().getSettings();
        Layouter currentLayouter = graphSettings.getCurrentLayouter();
        Layouter customLayouter = builder.getProvider().getExtras().getCustomLayouter(graphSettings, builder.getProject());
        if (customLayouter != null && currentLayouter.getClass() == customLayouter.getClass()) {
            DiagramLayout diagramLayout = CUSTOM;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(2);
            }
            return diagramLayout;
        }
        return DiagramLayout.from(currentLayouter);
    }

    @NotNull
    public static DiagramLayout from(@NotNull Layouter layouter) {
        if (layouter == null) {
            DiagramLayout.$$$reportNull$$$0(3);
        }
        if (layouter instanceof CompactOrthogonalLayouter) {
            DiagramLayout diagramLayout = COMPACT_ORTHOGONAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(4);
            }
            return diagramLayout;
        }
        if (layouter instanceof ComponentLayouter) {
            DiagramLayout diagramLayout = COMPONENT;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(5);
            }
            return diagramLayout;
        }
        if (layouter instanceof DirectedOrthogonalLayouter) {
            DiagramLayout diagramLayout = DIRECTED_ORTHOGONAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(6);
            }
            return diagramLayout;
        }
        if (layouter instanceof HierarchicGroupLayouter) {
            DiagramLayout diagramLayout = HIERARCHIC;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(7);
            }
            return diagramLayout;
        }
        if (layouter instanceof IncrementalHierarchicLayouter) {
            DiagramLayout diagramLayout = HIERARCHIC_COMPACT;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(8);
            }
            return diagramLayout;
        }
        if (layouter instanceof OrthogonalGroupLayouter) {
            DiagramLayout diagramLayout = ORTHOGONAL_GROUPS;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(9);
            }
            return diagramLayout;
        }
        if (layouter instanceof ChannelEdgeRouter) {
            DiagramLayout diagramLayout = CHANNEL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(10);
            }
            return diagramLayout;
        }
        if (layouter instanceof SeriesParallelLayouter) {
            DiagramLayout diagramLayout = SERIES_PARALLEL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(11);
            }
            return diagramLayout;
        }
        if (layouter instanceof CircularLayouter) {
            DiagramLayout diagramLayout = ((CircularLayouter)layouter).getEdgeBundling().getDefaultBundleDescriptor().isBundled() ? CIRCULAR_EDGE_BUNDLED : CIRCULAR;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(12);
            }
            return diagramLayout;
        }
        if (layouter instanceof RadialLayouter) {
            DiagramLayout diagramLayout = ((RadialLayouter)layouter).getEdgeBundling().getDefaultBundleDescriptor().isBundled() ? RADIAL_EDGE_BUNDLED : RADIAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(13);
            }
            return diagramLayout;
        }
        if (layouter instanceof SingleCycleLayouter) {
            DiagramLayout diagramLayout = SINGLE_CYCLE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(14);
            }
            return diagramLayout;
        }
        if (layouter instanceof ARTreeLayouter) {
            DiagramLayout diagramLayout = AR_TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(15);
            }
            return diagramLayout;
        }
        if (layouter instanceof BalloonLayouter) {
            DiagramLayout diagramLayout = BALLOON;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(16);
            }
            return diagramLayout;
        }
        if (layouter instanceof FamilyTreeLayouter) {
            DiagramLayout diagramLayout = FAMILY_TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(17);
            }
            return diagramLayout;
        }
        if (layouter instanceof GenericTreeLayouter) {
            DiagramLayout diagramLayout = GENERIC_TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(18);
            }
            return diagramLayout;
        }
        if (layouter instanceof HVTreeLayouter) {
            DiagramLayout diagramLayout = HV_TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(19);
            }
            return diagramLayout;
        }
        if (layouter instanceof RandomLayouter) {
            DiagramLayout diagramLayout = RANDOM;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(20);
            }
            return diagramLayout;
        }
        if (layouter instanceof OrganicEdgeRouter) {
            DiagramLayout diagramLayout = ORGANIC_EDGE_BUNDLED;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(21);
            }
            return diagramLayout;
        }
        if (layouter instanceof OrganicLayouter) {
            DiagramLayout diagramLayout = ORGANIC;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(22);
            }
            return diagramLayout;
        }
        DiagramLayout diagramLayout = HIERARCHIC;
        if (diagramLayout == null) {
            DiagramLayout.$$$reportNull$$$0(23);
        }
        return diagramLayout;
    }

    @NotNull
    public Layouter getLayouter(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramLayout.$$$reportNull$$$0(24);
        }
        GraphSettings settings = builder.getPresentationModel().getSettings();
        if (this == CUSTOM) {
            Layouter customLayouter = builder.getProvider().getExtras().getCustomLayouter(settings, builder.getProject());
            Object object = customLayouter != null ? customLayouter : GraphLayoutService.getInstance().getGroupLayouter();
            if (object == null) {
                DiagramLayout.$$$reportNull$$$0(25);
            }
            return object;
        }
        Layouter layouter = this.getPredefinedLayouter(settings);
        if (layouter == null) {
            DiagramLayout.$$$reportNull$$$0(26);
        }
        return layouter;
    }

    @NotNull
    public Layouter getPredefinedLayouter(@NotNull GraphSettings settings) {
        if (settings == null) {
            DiagramLayout.$$$reportNull$$$0(27);
        }
        switch (this) {
            case CUSTOM: {
                throw new IllegalArgumentException("Use getLayouter instead");
            }
            case COMPACT_ORTHOGONAL: {
                CompactOrthogonalLayouter compactOrthogonalLayouter = GraphLayoutService.getInstance().getCompactOrthogonalLayouter();
                if (compactOrthogonalLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(28);
                }
                return compactOrthogonalLayouter;
            }
            case COMPONENT: {
                ComponentLayouter componentLayouter = GraphLayoutService.getInstance().getComponentLayouter();
                if (componentLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(29);
                }
                return componentLayouter;
            }
            case DIRECTED_ORTHOGONAL: {
                DirectedOrthogonalLayouter directedOrthogonalLayouter = GraphLayoutService.getInstance().getDirectedOrthogonalLayouter();
                if (directedOrthogonalLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(30);
                }
                return directedOrthogonalLayouter;
            }
            case ORTHOGONAL_GROUPS: {
                OrthogonalGroupLayouter orthogonalGroupLayouter = GraphLayoutService.getInstance().getOrthogonalGroupLayouter();
                if (orthogonalGroupLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(31);
                }
                return orthogonalGroupLayouter;
            }
            case CHANNEL: {
                ChannelEdgeRouter channelEdgeRouter = GraphLayoutService.getInstance().getChannelLayouter();
                if (channelEdgeRouter == null) {
                    DiagramLayout.$$$reportNull$$$0(32);
                }
                return channelEdgeRouter;
            }
            case SERIES_PARALLEL: {
                SeriesParallelLayouter seriesParallelLayouter = GraphLayoutService.getInstance().getSeriesParallelLayouter();
                if (seriesParallelLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(33);
                }
                return seriesParallelLayouter;
            }
            case CIRCULAR: {
                CircularLayouter circularLayouter = GraphLayoutService.getInstance().getCircularLayouter();
                if (circularLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(34);
                }
                return circularLayouter;
            }
            case CIRCULAR_EDGE_BUNDLED: {
                CircularLayouter circularLayouter = GraphLayoutService.getInstance().getEdgeBundledCircularLayouter();
                if (circularLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(35);
                }
                return circularLayouter;
            }
            case RADIAL: {
                RadialLayouter radialLayouter = GraphLayoutService.getInstance().getRadialLayouter();
                if (radialLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(36);
                }
                return radialLayouter;
            }
            case RADIAL_EDGE_BUNDLED: {
                RadialLayouter radialLayouter = GraphLayoutService.getInstance().getEdgeBundledRadialLayouter();
                if (radialLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(37);
                }
                return radialLayouter;
            }
            case SINGLE_CYCLE: {
                SingleCycleLayouter singleCycleLayouter = GraphLayoutService.getInstance().getSingleCycleLayouter();
                if (singleCycleLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(38);
                }
                return singleCycleLayouter;
            }
            case AR_TREE: {
                ARTreeLayouter aRTreeLayouter = GraphLayoutService.getInstance().getARTreeLayouter();
                if (aRTreeLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(39);
                }
                return aRTreeLayouter;
            }
            case BALLOON: {
                BalloonLayouter balloonLayouter = GraphLayoutService.getInstance().getBalloonLayouter();
                if (balloonLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(40);
                }
                return balloonLayouter;
            }
            case BALLOON_EDGE_BUNDLED: {
                BalloonLayouter balloonLayouter = GraphLayoutService.getInstance().getEdgeBundledBalloonLayouter();
                if (balloonLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(41);
                }
                return balloonLayouter;
            }
            case FAMILY_TREE: {
                FamilyTreeLayouter familyTreeLayouter = GraphLayoutService.getInstance().getFamilyTreeLayouter();
                if (familyTreeLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(42);
                }
                return familyTreeLayouter;
            }
            case RANDOM: {
                RandomLayouter randomLayouter = GraphLayoutService.getInstance().getRandomLayouter();
                if (randomLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(43);
                }
                return randomLayouter;
            }
            case ORGANIC: {
                SmartOrganicLayouter smartOrganicLayouter = GraphLayoutService.getInstance().getOrganicLayouter();
                if (smartOrganicLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(44);
                }
                return smartOrganicLayouter;
            }
            case ORGANIC_EDGE_BUNDLED: {
                OrganicEdgeRouter organicEdgeRouter = GraphLayoutService.getInstance().getEdgeBundledOrganicLayouter();
                if (organicEdgeRouter == null) {
                    DiagramLayout.$$$reportNull$$$0(45);
                }
                return organicEdgeRouter;
            }
            case HIERARCHIC_COMPACT: {
                IncrementalHierarchicLayouter incrementalHierarchicLayouter = GraphLayoutService.getInstance().getHierarchicLayouter();
                if (incrementalHierarchicLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(46);
                }
                return incrementalHierarchicLayouter;
            }
        }
        HierarchicGroupLayouter hierarchicGroupLayouter = GraphLayoutService.getInstance().getGroupLayouter();
        if (hierarchicGroupLayouter == null) {
            DiagramLayout.$$$reportNull$$$0(47);
        }
        return hierarchicGroupLayouter;
    }

    @NlsSafe
    public String getPresentableName() {
        return DiagramBundle.message("diagram.layout." + StringUtil.toLowerCase((String)this.name()).replaceAll("_", "."), new Object[0]);
    }

    @NotNull
    public static DiagramLayout fromLocalizedString(@Nullable String name) {
        if (name == null) {
            return DiagramLayout.getDefault();
        }
        for (DiagramLayout value : DiagramLayout.values()) {
            if (!name.equals(value.getPresentableName())) continue;
            DiagramLayout diagramLayout = value;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(48);
            }
            return diagramLayout;
        }
        return DiagramLayout.getDefault();
    }

    public static DiagramLayout fromString(Object obj) {
        if (obj == null) {
            return DiagramLayout.getDefault();
        }
        String name = obj.toString();
        try {
            return DiagramLayout.valueOf(StringUtil.toUpperCase((String)name).replaceAll(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            return DiagramLayout.getDefault();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 24: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 24: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/settings/DiagramLayout";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 1: 
            case 3: 
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/settings/DiagramLayout";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayout";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayouter";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLayouter";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLocalizedString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentLayout";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLayouter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLayouter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 24: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

