/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.extras.custom;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.components.ScalableIconWrapper;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CommonDiagramExtras<T>
extends DiagramExtras<T> {
    public static final DiagramCategory SELECTION_MODE = new DiagramCategory(DiagramBundle.messagePointer("category.name.show.neighbours.of.selected.nodes", new Object[0]), AllIcons.Graph.NodeSelectionMode, false, true, true, true);
    public static final DiagramCategory BORDERS = new DiagramCategory(DiagramBundle.messagePointer("category.name.show.borders", new Object[0]), AllIcons.Graph.SnapToGrid, true, false, false);
    public static final DiagramCategory PATH_TO_ROOT = new DiagramCategory(DiagramBundle.messagePointer("category.name.show.paths.root.selection", new Object[0]), AllIcons.Hierarchy.Subtypes, false, true, true, true);

    @Override
    @NotNull
    public JComponent createNodeComponent(@NotNull DiagramNode<T> node, @NotNull DiagramBuilder builder, @NotNull Point basePoint, @NotNull JPanel wrapper) {
        if (node == null) {
            CommonDiagramExtras.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            CommonDiagramExtras.$$$reportNull$$$0(1);
        }
        if (basePoint == null) {
            CommonDiagramExtras.$$$reportNull$$$0(2);
        }
        if (wrapper == null) {
            CommonDiagramExtras.$$$reportNull$$$0(3);
        }
        JComponent jComponent = this.createLabelNode(node, builder, wrapper);
        if (jComponent == null) {
            CommonDiagramExtras.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @NotNull
    public JComponent createLabelNode(@NotNull DiagramNode<T> node, @NotNull DiagramBuilder builder, @NotNull JPanel wrapper) {
        if (node == null) {
            CommonDiagramExtras.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            CommonDiagramExtras.$$$reportNull$$$0(6);
        }
        if (wrapper == null) {
            CommonDiagramExtras.$$$reportNull$$$0(7);
        }
        this.setNodeBorders(node, builder, wrapper);
        wrapper.setBackground(builder.getColorScheme().getDefaultBackground());
        SimpleColoredComponent simpleColoredComponent = this.createLabel(builder, node);
        if (simpleColoredComponent == null) {
            CommonDiagramExtras.$$$reportNull$$$0(8);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public SimpleColoredComponent createLabel(@NotNull DiagramBuilder builder, @NotNull DiagramNode<T> node) {
        Icon icon;
        if (builder == null) {
            CommonDiagramExtras.$$$reportNull$$$0(9);
        }
        if (node == null) {
            CommonDiagramExtras.$$$reportNull$$$0(10);
        }
        SimpleColoredComponent label = new SimpleColoredComponent();
        label.setOpaque(false);
        label.setIconOpaque(false);
        label.setForeground(builder.getColorScheme().getDefaultForeground());
        DiagramElementManager<?> manager = builder.getProvider().getElementManager();
        SimpleColoredText presentableName = manager.getPresentableElementTitle(node.getIdentifyingElement(), builder);
        if (presentableName != null) {
            presentableName.appendToComponent((ColoredTextContainer)label);
        }
        label.setIcon((Icon)((icon = node.getIcon()) != null ? ScalableIconWrapper.evaluateDeferredAndWrap(icon) : null));
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            CommonDiagramExtras.$$$reportNull$$$0(11);
        }
        return simpleColoredComponent;
    }

    protected void setNodeBorders(@NotNull DiagramNode<T> node, @NotNull DiagramBuilder builder, @NotNull JPanel wrapper) {
        if (node == null) {
            CommonDiagramExtras.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            CommonDiagramExtras.$$$reportNull$$$0(13);
        }
        if (wrapper == null) {
            CommonDiagramExtras.$$$reportNull$$$0(14);
        }
        DiagramNodeContentManager nodeContentManager = builder.getDataModel().getNodeContentManager();
        DiagramColorManager colorManager = builder.getProvider().getColorManager();
        boolean isSelected = builder.getGraph().isSelected(builder.getNode(node));
        wrapper.setBorder(isSelected || nodeContentManager.isCategoryEnabled(BORDERS) ? JBUI.Borders.customLine((Color)colorManager.getNodeBorderColor(builder, node, isSelected)) : JBUI.Borders.empty());
    }

    @Override
    public boolean isZoomAnimationsEnabled() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePoint";
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/extras/custom/CommonDiagramExtras";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/extras/custom/CommonDiagramExtras";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelNode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNodeComponent";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLabelNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNodeBorders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

