/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.python;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.python.PyFileReferenceContext;
import com.intellij.protobuf.shared.gencode.ProtoFromSourceComments;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyFile;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PbPythonGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public String getActionText(@NotNull DataContext context) {
        if (context == null) {
            PbPythonGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        return null;
    }

    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        if (sourceElement == null) {
            return null;
        }
        if (!sourceElement.getLanguage().is((Language)PythonLanguage.INSTANCE)) {
            return null;
        }
        PyFileReferenceContext context = PyFileReferenceContext.findContext(sourceElement);
        if (context == null) {
            return null;
        }
        ImmutableCollection<? extends PbElement> matches = PbPythonGotoDeclarationHandler.pythonToProto(context);
        if (matches.isEmpty()) {
            return null;
        }
        return matches.toArray((PsiElement[])PsiElement.EMPTY_ARRAY);
    }

    private static ImmutableCollection<? extends PbElement> pythonToProto(PyFileReferenceContext referenceContext) {
        PyFile file = referenceContext.getFile();
        String fileName = file.getName();
        Integer apiVersion = null;
        PbFile protoSource = null;
        if (fileName.endsWith("_pb2.py")) {
            protoSource = PbPythonGotoDeclarationHandler.findSourceOfGeneratedPy(file);
            apiVersion = 2;
        } else if (fileName.endsWith("_pb.py")) {
            protoSource = PbPythonGotoDeclarationHandler.findSourceOfGeneratedPy(file);
            apiVersion = 1;
        }
        if (protoSource == null) {
            return ImmutableList.of();
        }
        ImmutableCollection<? extends PbElement> results = PbPythonGotoDeclarationHandler.locateSymbolInProtoFile(protoSource, referenceContext.getFileLocalSymbol());
        if (results.isEmpty() && apiVersion == 1) {
            return PbPythonGotoDeclarationHandler.locateWithNormalizedNames(protoSource, referenceContext.getFileLocalSymbol());
        }
        return results;
    }

    @Nullable
    private static PbFile findSourceOfGeneratedPy(PyFile file) {
        return ProtoFromSourceComments.findProtoOfGeneratedCode("#", (PsiFile)file);
    }

    private static ImmutableCollection<? extends PbElement> locateSymbolInProtoFile(PbFile pbFile, QualifiedName fileLocalSymbol) {
        if (fileLocalSymbol.getComponents().isEmpty()) {
            return ImmutableList.of((Object)pbFile);
        }
        QualifiedName qualifiedName = pbFile.getPackageQualifiedName().append(fileLocalSymbol);
        ImmutableMultimap<QualifiedName, PbSymbol> fileSymbols = pbFile.getLocalQualifiedSymbolMap();
        return ImmutableList.copyOf((Collection)fileSymbols.get((Object)qualifiedName));
    }

    private static ImmutableCollection<? extends PbElement> locateWithNormalizedNames(PbFile pbFile, QualifiedName fileLocalName) {
        String fileLocalSymbol = fileLocalName.toString();
        if (!fileLocalSymbol.contains("_")) {
            return ImmutableList.of();
        }
        String desiredSymbol = fileLocalSymbol.replace('.', '_');
        ImmutableMultimap<QualifiedName, PbSymbol> fileSymbols = pbFile.getLocalQualifiedSymbolMap();
        int numPackageComponents = pbFile.getPackageQualifiedName().getComponentCount();
        List matches = fileSymbols.entries().stream().filter(entry -> {
            QualifiedName qualifiedName = (QualifiedName)entry.getKey();
            String candidateLastComponent = qualifiedName.getLastComponent();
            if (candidateLastComponent == null || !desiredSymbol.endsWith(candidateLastComponent)) {
                return false;
            }
            return qualifiedName.removeHead(numPackageComponents).join("_").equals(desiredSymbol);
        }).map(Map.Entry::getValue).collect(Collectors.toList());
        return ImmutableList.copyOf(matches);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/protobuf/python/PbPythonGotoDeclarationHandler", "getActionText"));
    }
}

