/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve.directive;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiReference;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemaComment {
    private final PsiComment comment;
    private final TextRange keyRange;
    private final TextRange nameRange;
    private final Type type;

    SchemaComment(@NotNull PsiComment comment, TextRange keyRange, TextRange nameRange, Type type) {
        if (comment == null) {
            SchemaComment.$$$reportNull$$$0(0);
        }
        this.comment = comment;
        this.keyRange = keyRange;
        this.nameRange = nameRange;
        this.type = type;
    }

    @NotNull
    public PsiComment getComment() {
        PsiComment psiComment = this.comment;
        if (psiComment == null) {
            SchemaComment.$$$reportNull$$$0(1);
        }
        return psiComment;
    }

    @Nullable
    public TextRange getKeyRange() {
        return this.keyRange;
    }

    @Nullable
    public TextRange getNameRange() {
        return this.nameRange;
    }

    @Nullable
    public String getName() {
        return this.nameRange != null ? this.nameRange.substring(this.comment.getText()) : null;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public abstract PsiReference getReference();

    public abstract List<PsiReference> getAllReferences();

    public int hashCode() {
        return Objects.hash(this.comment, this.keyRange, this.nameRange);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SchemaComment)) {
            return false;
        }
        SchemaComment otherComment = (SchemaComment)other;
        return Objects.equals(this.comment, otherComment.comment) && Objects.equals(this.keyRange, otherComment.keyRange) && Objects.equals(this.nameRange, otherComment.nameRange);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/directive/SchemaComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/directive/SchemaComment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        FILE,
        MESSAGE,
        IMPORT;

    }
}

