/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.lang.annotation.OptionOccurrenceTracker;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbSimpleField;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbTextFieldName;
import com.intellij.protobuf.lang.psi.PbTextMessage;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.lang.resolve.PbSymbolLookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbTextFieldNameReference
extends PsiReferenceBase<PbTextFieldName> {
    public PbTextFieldNameReference(@NotNull PbTextFieldName element) {
        if (element == null) {
            PbTextFieldNameReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
    }

    @Nullable
    protected TextRange calculateDefaultRangeInElement() {
        return TextRange.create((int)0, (int)((PbTextFieldName)this.myElement).getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        ResolveCache cache = ResolveCache.getInstance((Project)((PbTextFieldName)this.myElement).getProject());
        return (PsiElement)cache.resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)Resolver.INSTANCE, false, false);
    }

    private PbField resolveNoCache() {
        PsiElement identifier = ((PbTextFieldName)this.myElement).getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        String name = identifier.getText();
        return PbTextFieldNameReference.resolveNamedFieldInType(name, PbTextFieldNameReference.getContainingMessage((PbTextFieldName)this.myElement));
    }

    private static PbMessageType getContainingMessage(PbTextFieldName name) {
        PbTextMessage parentMessage = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)name, PbTextMessage.class);
        if (parentMessage == null) {
            return null;
        }
        return parentMessage.getDeclaredMessage();
    }

    @Nullable
    private static PbField resolveNamedFieldInType(String name, PbMessageType type) {
        if (type == null) {
            return null;
        }
        PbSymbol symbol = type.getSymbolMap().get((Object)name).stream().filter(s -> s instanceof PbField || s instanceof PbGroupDefinition).findFirst().orElse(null);
        if (symbol instanceof PbGroupDefinition) {
            PbSimpleField generatedField = ((PbGroupDefinition)symbol).getGeneratedField();
            if (generatedField == null || generatedField.isExtension()) {
                return null;
            }
            return generatedField;
        }
        if (symbol instanceof PbField) {
            PbField field = (PbField)symbol;
            if (field.isExtension()) {
                return null;
            }
            PbTypeName fieldType = field.getTypeName();
            if (fieldType == null) {
                return null;
            }
            PbGroupDefinition group = PbPsiUtil.resolveRefToType(fieldType.getEffectiveReference(), PbGroupDefinition.class);
            if (group != null && !name.equals(group.getName())) {
                return null;
            }
            return field;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        PbMessageType qualifierType = PbTextFieldNameReference.getContainingMessage((PbTextFieldName)this.myElement);
        if (qualifierType == null) {
            if (LookupElement.EMPTY_ARRAY == null) {
                PbTextFieldNameReference.$$$reportNull$$$0(1);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        OptionOccurrenceTracker.Occurrence occurrence = this.getOccurrence();
        Collection fields = qualifierType.getSymbols(PbField.class);
        ArrayList<PbSymbolLookupElement> variants = new ArrayList<PbSymbolLookupElement>(fields.size());
        for (PbField field : fields) {
            PbTypeName fieldType;
            if (field.isExtension() || field.getName() == null || (fieldType = field.getTypeName()) == null) continue;
            PbGroupDefinition group = PbPsiUtil.resolveRefToType(fieldType.getEffectiveReference(), PbGroupDefinition.class);
            if (group != null) {
                variants.add(PbSymbolLookupElement.forGroupDefinitionAsField(group, occurrence));
                continue;
            }
            variants.add(PbSymbolLookupElement.withUnusableFieldHighlight(field, occurrence));
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            PbTextFieldNameReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) {
        ASTNode node;
        PsiElement identifier;
        if (newElementName == null) {
            PbTextFieldNameReference.$$$reportNull$$$0(3);
        }
        if ((identifier = ((PbTextFieldName)this.getElement()).getNameIdentifier()) != null && (node = identifier.getNode()) instanceof LeafElement) {
            ((LeafElement)node).replaceWithText(newElementName);
            return identifier;
        }
        return super.handleElementRename(newElementName);
    }

    private OptionOccurrenceTracker.Occurrence getOccurrence() {
        PbTextMessage parent = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PbTextMessage.class);
        if (parent == null) {
            return null;
        }
        OptionOccurrenceTracker tracker = OptionOccurrenceTracker.forMessage(parent);
        if (tracker == null) {
            return null;
        }
        return tracker.getOccurrence(parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/PbTextFieldNameReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/PbTextFieldNameReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.Resolver {
        private static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @Nullable
        public PsiElement resolve(@NotNull PsiReference ref, boolean incompleteCode) {
            if (ref == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            return ((PbTextFieldNameReference)ref).resolveNoCache();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/protobuf/lang/resolve/PbTextFieldNameReference$Resolver", "resolve"));
        }
    }
}

