/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.intellij.openapi.util.Condition;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.resolve.PbResolveResult;
import com.intellij.protobuf.lang.resolve.ResolveFilters;
import com.intellij.psi.util.QualifiedName;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PbSymbolResolver {
    private final Multimap<QualifiedName, PbSymbol> symbols;

    private PbSymbolResolver(Multimap<QualifiedName, PbSymbol> symbols) {
        this.symbols = symbols;
    }

    public static PbSymbolResolver forFile(PbFile file) {
        return new PbSymbolResolver((Multimap<QualifiedName, PbSymbol>)file.getFullQualifiedSymbolMap());
    }

    public static PbSymbolResolver forFileExports(PbFile file) {
        return new PbSymbolResolver((Multimap<QualifiedName, PbSymbol>)file.getExportedQualifiedSymbolMap());
    }

    public static PbSymbolResolver forFileExports(List<PbFile> files) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (PbFile file : files) {
            builder.putAll(file.getExportedQualifiedSymbolMap());
        }
        return new PbSymbolResolver((Multimap<QualifiedName, PbSymbol>)builder.build());
    }

    public static PbSymbolResolver empty() {
        return new PbSymbolResolver((Multimap<QualifiedName, PbSymbol>)ImmutableMultimap.of());
    }

    public List<PbResolveResult> resolveRelativeName(QualifiedName name, QualifiedName scope, Condition<PbSymbol> condition) {
        if (name.getComponentCount() == 0) {
            return Collections.emptyList();
        }
        if (scope == null) {
            return Collections.emptyList();
        }
        while (scope.getComponentCount() > 0) {
            if (name.getComponentCount() == 1) {
                List<PbResolveResult> results = this.resolveName(scope.append(name), condition);
                if (!results.isEmpty()) {
                    return results;
                }
            } else if (this.symbolOwnerExists(scope.append(name.getFirstComponent()))) {
                return this.resolveName(scope.append(name), condition);
            }
            scope = scope.removeLastComponent();
        }
        return this.resolveName(name, condition);
    }

    public List<PbResolveResult> resolveName(QualifiedName name, Condition<PbSymbol> condition) {
        return this.symbols.get((Object)name).stream().filter(arg_0 -> condition.value(arg_0)).map(PbResolveResult::create).collect(Collectors.toList());
    }

    public ImmutableMultimap<String, PbSymbol> findChildren(QualifiedName parentName, Condition<PbSymbol> condition) {
        if (parentName.getComponentCount() == 0) {
            return this.findTopLevelSymbols(condition);
        }
        List<PbResolveResult> parentResults = this.resolveName(parentName, ResolveFilters.packageOrType());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        parentResults.stream().map(PbResolveResult::getElement).filter(element -> element instanceof PbSymbolOwner).map(element -> ((PbSymbolOwner)((Object)element)).getSymbols()).flatMap(Collection::stream).filter(arg_0 -> condition.value(arg_0)).forEach(symbol -> {
            String name = symbol.getName();
            if (name != null) {
                builder.put((Object)name, symbol);
            }
        });
        return builder.build();
    }

    private ImmutableMultimap<String, PbSymbol> findTopLevelSymbols(Condition<PbSymbol> condition) {
        Multimap filtered = Multimaps.filterEntries(this.symbols, e -> e != null && ((QualifiedName)e.getKey()).getComponentCount() == 1 && condition.value((Object)((PbSymbol)e.getValue())));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry entry : filtered.asMap().entrySet()) {
            String first;
            QualifiedName name = (QualifiedName)entry.getKey();
            if (name == null || (first = name.getFirstComponent()) == null) continue;
            builder.putAll((Object)first, (Iterable)entry.getValue());
        }
        return builder.build();
    }

    private boolean symbolOwnerExists(QualifiedName symbol) {
        return !this.resolveName(symbol, ResolveFilters.symbolOwner()).isEmpty();
    }
}

