/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.lang.annotation.OptionOccurrenceTracker;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbOptionOwner;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.protobuf.lang.resolve.PbSymbolLookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbOptionNameReference
extends PsiReferenceBase<PbOptionName> {
    public PbOptionNameReference(@NotNull PbOptionName element) {
        if (element == null) {
            PbOptionNameReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
    }

    @Nullable
    protected TextRange calculateDefaultRangeInElement() {
        PsiElement symbol = ((PbOptionName)this.myElement).getSymbol();
        if (symbol == null) {
            return null;
        }
        TextRange outerRange = ((PbOptionName)this.myElement).getTextRange();
        TextRange identifierRange = symbol.getTextRange();
        return TextRange.from((int)(identifierRange.getStartOffset() - outerRange.getStartOffset()), (int)identifierRange.getLength());
    }

    @Nullable
    public PsiElement resolve() {
        ResolveCache cache = ResolveCache.getInstance((Project)((PbOptionName)this.myElement).getProject());
        return (PsiElement)cache.resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)Resolver.INSTANCE, false, false);
    }

    private PbField resolveNoCache() {
        PsiElement symbol = ((PbOptionName)this.myElement).getSymbol();
        if (symbol == null) {
            return null;
        }
        String name = symbol.getText();
        return PbOptionNameReference.resolveNamedFieldInType(name, ((PbOptionName)this.myElement).getQualifierType());
    }

    @Nullable
    private static PbField resolveNamedFieldInType(String name, PbMessageType type) {
        if (type == null) {
            return null;
        }
        return type.getSymbolMap().get((Object)name).stream().filter(symbol -> symbol instanceof PbField).map(symbol -> (PbField)symbol).filter(field -> !field.isExtension()).findFirst().orElse(null);
    }

    @NotNull
    public Object[] getVariants() {
        PbMessageType qualifierType = ((PbOptionName)this.myElement).getQualifierType();
        if (qualifierType == null) {
            if (LookupElement.EMPTY_ARRAY == null) {
                PbOptionNameReference.$$$reportNull$$$0(1);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        OptionOccurrenceTracker.Occurrence occurrence = this.getOccurrence();
        Collection fields = qualifierType.getSymbols(PbField.class);
        ArrayList<PbSymbolLookupElement> variants = new ArrayList<PbSymbolLookupElement>(fields.size());
        for (PbField field : fields) {
            if (field.isExtension() || field.getName() == null) continue;
            variants.add(PbSymbolLookupElement.withUnmergeableFieldHighlight(field, occurrence));
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            PbOptionNameReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private OptionOccurrenceTracker.Occurrence getOccurrence() {
        PbOptionOwner owner = PbPsiImplUtil.getOptionOwner(this.getElement());
        if (owner == null) {
            return null;
        }
        OptionOccurrenceTracker tracker = OptionOccurrenceTracker.forOptionOwner(owner);
        PbOptionName qualifier = ((PbOptionName)this.getElement()).getQualifier();
        if (qualifier != null) {
            return tracker.getOccurrence(qualifier);
        }
        return tracker.getRootOccurrence();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/PbOptionNameReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/PbOptionNameReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.Resolver {
        private static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @Nullable
        public PsiElement resolve(@NotNull PsiReference ref, boolean incompleteCode) {
            if (ref == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            return ((PbOptionNameReference)ref).resolveNoCache();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/protobuf/lang/resolve/PbOptionNameReference$Resolver", "resolve"));
        }
    }
}

