/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.resolve.FileResolveProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class PbFileResolver {
    @NotNull
    public static List<PbFile> findFilesForContext(@NotNull String path, @NotNull PsiElement context) {
        Module module;
        if (path == null) {
            PbFileResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PbFileResolver.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null) {
            return PbFileResolver.findFilesInModule(path, module);
        }
        return PbFileResolver.findFilesInProject(path, context.getProject());
    }

    @NotNull
    public static List<PbFile> findFilesInModule(@NotNull String path, @NotNull Module module) {
        if (path == null) {
            PbFileResolver.$$$reportNull$$$0(2);
        }
        if (module == null) {
            PbFileResolver.$$$reportNull$$$0(3);
        }
        if (!PbFileResolver.isValidImportPath(path)) {
            List<PbFile> list = Collections.emptyList();
            if (list == null) {
                PbFileResolver.$$$reportNull$$$0(4);
            }
            return list;
        }
        return PbFileResolver.findFiles(module.getProject(), provider -> provider.findFile(path, module));
    }

    @NotNull
    public static List<PbFile> findFilesInProject(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            PbFileResolver.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PbFileResolver.$$$reportNull$$$0(6);
        }
        if (!PbFileResolver.isValidImportPath(path)) {
            List<PbFile> list = Collections.emptyList();
            if (list == null) {
                PbFileResolver.$$$reportNull$$$0(7);
            }
            return list;
        }
        return PbFileResolver.findFiles(project, provider -> provider.findFile(path, project));
    }

    @NotNull
    public static Collection<FileResolveProvider.ChildEntry> getChildNamesForContext(@NotNull String path, @NotNull PsiElement context) {
        Module module;
        if (path == null) {
            PbFileResolver.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PbFileResolver.$$$reportNull$$$0(9);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null) {
            return PbFileResolver.getChildNamesInModule(path, module);
        }
        return PbFileResolver.getChildNamesInProject(path, context.getProject());
    }

    @NotNull
    public static Collection<FileResolveProvider.ChildEntry> getChildNamesInModule(@NotNull String path, @NotNull Module module) {
        if (path == null) {
            PbFileResolver.$$$reportNull$$$0(10);
        }
        if (module == null) {
            PbFileResolver.$$$reportNull$$$0(11);
        }
        if (!PbFileResolver.isValidImportPath(path)) {
            List<FileResolveProvider.ChildEntry> list = Collections.emptyList();
            if (list == null) {
                PbFileResolver.$$$reportNull$$$0(12);
            }
            return list;
        }
        return PbFileResolver.getChildEntries(module.getProject(), provider -> provider.getChildEntries(path, module));
    }

    @NotNull
    public static Collection<FileResolveProvider.ChildEntry> getChildNamesInProject(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            PbFileResolver.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PbFileResolver.$$$reportNull$$$0(14);
        }
        if (!PbFileResolver.isValidImportPath(path)) {
            List<FileResolveProvider.ChildEntry> list = Collections.emptyList();
            if (list == null) {
                PbFileResolver.$$$reportNull$$$0(15);
            }
            return list;
        }
        return PbFileResolver.getChildEntries(project, provider -> provider.getChildEntries(path, project));
    }

    public static boolean isValidImportPath(@NotNull String path) {
        if (path == null) {
            PbFileResolver.$$$reportNull$$$0(16);
        }
        return !path.contains("//") && !path.contains("\\") && !path.contains("/./") && !path.contains("/../") && !path.startsWith("./") && !path.startsWith("../") && !path.endsWith("/.") && !path.endsWith("/..") && !path.equals(".") && !path.equals("..");
    }

    @NotNull
    static FileResolveProvider[] getProviders(@NotNull Project project) {
        if (project == null) {
            PbFileResolver.$$$reportNull$$$0(17);
        }
        FileResolveProvider[] fileResolveProviderArray = (FileResolveProvider[])FileResolveProvider.EP_NAME.getExtensions((AreaInstance)project);
        if (fileResolveProviderArray == null) {
            PbFileResolver.$$$reportNull$$$0(18);
        }
        return fileResolveProviderArray;
    }

    static GlobalSearchScope getUnionScope(@NotNull Project project) {
        if (project == null) {
            PbFileResolver.$$$reportNull$$$0(19);
        }
        GlobalSearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
        for (FileResolveProvider provider : PbFileResolver.getProviders(project)) {
            scope = scope.union((SearchScope)provider.getSearchScope(project));
        }
        return scope;
    }

    @NotNull
    private static List<PbFile> findFiles(Project project, Function<FileResolveProvider, VirtualFile> fn) {
        LinkedHashSet<PbFile> results = new LinkedHashSet<PbFile>();
        for (FileResolveProvider provider : PbFileResolver.getProviders(project)) {
            PsiFile psiFile;
            VirtualFile file = fn.apply(provider);
            if (file == null || !file.exists() || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof PbFile)) continue;
            results.add((PbFile)psiFile);
        }
        return new ArrayList<PbFile>(results);
    }

    @NotNull
    private static Collection<FileResolveProvider.ChildEntry> getChildEntries(Project project, Function<FileResolveProvider, Collection<FileResolveProvider.ChildEntry>> fn) {
        LinkedHashSet<FileResolveProvider.ChildEntry> results = new LinkedHashSet<FileResolveProvider.ChildEntry>();
        for (FileResolveProvider provider : PbFileResolver.getProviders(project)) {
            results.addAll(fn.apply(provider));
        }
        LinkedHashSet<FileResolveProvider.ChildEntry> linkedHashSet = results;
        if (linkedHashSet == null) {
            PbFileResolver.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/PbFileResolver";
                break;
            }
            case 6: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/PbFileResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesInModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesInProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNamesInModule";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNamesInProject";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFilesForContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFilesInModule";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFilesInProject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildNamesForContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChildNamesInModule";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChildNamesInProject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidImportPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getUnionScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

