/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.ProtoIdentifierValue;
import com.intellij.protobuf.lang.resolve.PbSymbolLookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbEnumValueReference
extends PsiReferenceBase<ProtoIdentifierValue> {
    @NotNull
    private final PbEnumDefinition enumDefinition;

    public PbEnumValueReference(@NotNull ProtoIdentifierValue element, @NotNull PbEnumDefinition enumDefinition) {
        if (element == null) {
            PbEnumValueReference.$$$reportNull$$$0(0);
        }
        if (enumDefinition == null) {
            PbEnumValueReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)element);
        this.enumDefinition = enumDefinition;
    }

    @Nullable
    protected TextRange calculateDefaultRangeInElement() {
        return TextRange.create((int)0, (int)((ProtoIdentifierValue)this.myElement).getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        String valueName = ((ProtoIdentifierValue)this.myElement).getText();
        return this.enumDefinition.getEnumValueMap().get((Object)valueName).stream().findFirst().orElse(null);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.enumDefinition.getEnumValues().stream().map(PbSymbolLookupElement::new).distinct().toArray();
        if (objectArray == null) {
            PbEnumValueReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ASTNode node;
        PsiElement element;
        if (newElementName == null) {
            PbEnumValueReference.$$$reportNull$$$0(3);
        }
        if ((element = ((ProtoIdentifierValue)this.getElement()).getIdentifierLiteral()) != null && (node = element.getNode()) instanceof LeafElement) {
            ((LeafElement)node).replaceWithText(newElementName);
            return element;
        }
        return super.handleElementRename(newElementName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumDefinition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/PbEnumValueReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/PbEnumValueReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

