/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;

public class PbCommentUtil {
    private static final Pattern LINE_COMMENT_START = Pattern.compile("^((//)|#)");
    private static final Pattern BLOCK_COMMENT_START_END = Pattern.compile("(^/\\*)|(\\*/$)");
    private static final Pattern BLOCK_COMMENT_INTERIOR = Pattern.compile("^[ \\t\\r\\f\\x0b]*\\*");

    public static List<PsiComment> collectLeadingComments(PsiElement element) {
        PsiElement start = PbCommentUtil.backup(element);
        CommentCollector collector = new CommentCollector();
        PbCommentUtil.collectComments(element.getContainingFile(), start, collector);
        return collector.getLeadingComments();
    }

    public static List<PsiComment> collectTrailingComments(PsiElement element) {
        CommentCollector collector = new CommentCollector();
        PbCommentUtil.collectComments(element.getContainingFile(), element, collector);
        return collector.getTrailingComments();
    }

    public static List<String> extractText(List<PsiComment> comments) {
        ArrayList<String> result = new ArrayList<String>(comments.size());
        for (PsiComment psiComment : comments) {
            if (PbPsiUtil.isLineComment((PsiElement)psiComment)) {
                result.add(PbCommentUtil.stripLineCommentStart(psiComment.getText()));
                continue;
            }
            if (!PbPsiUtil.isBlockComment((PsiElement)psiComment)) continue;
            result.addAll(PbCommentUtil.splitAndStripBlockCommentLines(psiComment.getText()));
        }
        int commonSpaces = Integer.MAX_VALUE;
        for (String string : result) {
            int spaces = PbCommentUtil.countLeadingSpaces(string);
            if (spaces < 0 || spaces >= commonSpaces) continue;
            commonSpaces = spaces;
        }
        ListIterator<String> listIterator = result.listIterator();
        while (listIterator.hasNext()) {
            String string;
            string = (String)listIterator.next();
            if (StringUtil.isEmptyOrSpaces((String)string)) {
                string = "";
            } else if (commonSpaces > 0 && string.length() > commonSpaces) {
                string = string.substring(commonSpaces);
            }
            listIterator.set(StringUtil.trimTrailing((String)string));
        }
        return result;
    }

    private static String stripLineCommentStart(String lineComment) {
        return LINE_COMMENT_START.matcher(lineComment).replaceAll("");
    }

    private static List<String> splitAndStripBlockCommentLines(String blockComment) {
        String withoutStartAndEnd = BLOCK_COMMENT_START_END.matcher(blockComment).replaceAll("");
        String[] lines = withoutStartAndEnd.split("\n");
        ArrayList<String> result = new ArrayList<String>(lines.length);
        if (!StringUtil.isEmptyOrSpaces((String)lines[0])) {
            result.add(lines[0]);
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = BLOCK_COMMENT_INTERIOR.matcher(lines[i]).replaceAll("");
            if (i == lines.length - 1 && StringUtil.isEmptyOrSpaces((String)line)) continue;
            result.add(line);
        }
        return result;
    }

    private static int countLeadingSpaces(String string) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') {
                ++count;
                continue;
            }
            return count;
        }
        return -1;
    }

    private static PsiElement backup(PsiElement leaf) {
        while ((leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf)) != null && (PbPsiUtil.isComment(leaf) || PbPsiUtil.isWhitespace(leaf))) {
        }
        return leaf;
    }

    private static void collectComments(PsiFile file, PsiElement start, CommentCollector collector) {
        PsiElement leaf;
        if (start == null) {
            leaf = PsiTreeUtil.getDeepestFirst((PsiElement)file);
            collector.detach();
        } else {
            leaf = PbCommentUtil.nextLeaf(start);
            if (PbPsiUtil.isLineComment(leaf)) {
                collector.addLineComment((PsiComment)leaf);
                leaf = PbCommentUtil.nextLeaf(leaf);
                collector.flush();
            } else if (PbPsiUtil.isBlockComment(leaf)) {
                collector.addBlockComment((PsiComment)leaf);
                leaf = PbCommentUtil.nextLeaf(leaf);
                if (!PbCommentUtil.isWhitespaceWithNewline(leaf)) {
                    collector.clear();
                    return;
                }
                collector.flush();
            } else if (!PbCommentUtil.isWhitespaceWithNewline(leaf)) {
                return;
            }
        }
        leaf = PbCommentUtil.skipWhitespaceWithoutBlankLine(leaf);
        while (true) {
            if (PbPsiUtil.isLineComment(leaf = PbCommentUtil.skipWhitespaceWithoutNewline(leaf))) {
                collector.addLineComment((PsiComment)leaf);
            } else if (PbPsiUtil.isBlockComment(leaf)) {
                collector.addBlockComment((PsiComment)leaf);
            } else if (PbPsiUtil.isWhitespace(leaf)) {
                if (PbCommentUtil.isWhitespaceWithBlankLine(leaf)) {
                    collector.flush();
                    collector.detach();
                }
            } else {
                if (leaf == null || PbCommentUtil.isEndOfBlock(leaf)) {
                    collector.flush();
                }
                return;
            }
            leaf = PbCommentUtil.nextLeaf(leaf);
        }
    }

    private static PsiElement nextLeaf(PsiElement leaf) {
        leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        return PbCommentUtil.skipWhitespaceWithoutNewline(leaf);
    }

    private static int countNewlines(CharSequence whitespace, int max) {
        int count = 0;
        for (int i = 0; i < whitespace.length() && count < max; ++i) {
            if (whitespace.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    private static boolean isWhitespaceWithNewline(PsiElement element) {
        return PbPsiUtil.isWhitespace(element) && PbCommentUtil.countNewlines(element.getText(), 1) > 0;
    }

    private static boolean isWhitespaceWithBlankLine(PsiElement element) {
        return PbPsiUtil.isWhitespace(element) && PbCommentUtil.countNewlines(element.getText(), 2) > 1;
    }

    private static boolean isEndOfBlock(PsiElement element) {
        return PbPsiUtil.isElementType(element, ProtoTokenTypes.RBRACE) || PbPsiUtil.isElementType(element, ProtoTokenTypes.RBRACK) || PbPsiUtil.isElementType(element, ProtoTokenTypes.RPAREN);
    }

    private static PsiElement skipWhitespaceWithoutNewline(PsiElement leaf) {
        while (PbPsiUtil.isWhitespace(leaf) && !PbCommentUtil.isWhitespaceWithNewline(leaf)) {
            leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        }
        return leaf;
    }

    private static PsiElement skipWhitespaceWithoutBlankLine(PsiElement leaf) {
        while (PbPsiUtil.isWhitespace(leaf) && !PbCommentUtil.isWhitespaceWithBlankLine(leaf)) {
            leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        }
        return leaf;
    }

    private static class CommentCollector {
        private boolean hasLineComment = false;
        private boolean canAttachToPrevious = true;
        private List<PsiComment> buffer = null;
        private List<PsiComment> trailingComments = null;

        private CommentCollector() {
        }

        void flush() {
            if (this.buffer != null) {
                if (this.canAttachToPrevious) {
                    this.trailingComments = this.buffer;
                    this.canAttachToPrevious = false;
                }
                this.clear();
            }
        }

        void addLineComment(PsiComment comment) {
            if (this.buffer != null && !this.hasLineComment) {
                this.flush();
            }
            this.hasLineComment = true;
            this.initAndAdd(comment);
        }

        void addBlockComment(PsiComment comment) {
            if (this.buffer != null) {
                this.flush();
            }
            this.hasLineComment = false;
            this.initAndAdd(comment);
        }

        void clear() {
            this.buffer = null;
        }

        void detach() {
            this.canAttachToPrevious = false;
        }

        List<PsiComment> getLeadingComments() {
            if (this.buffer == null) {
                return Collections.emptyList();
            }
            return this.buffer;
        }

        List<PsiComment> getTrailingComments() {
            if (this.trailingComments == null) {
                return Collections.emptyList();
            }
            return this.trailingComments;
        }

        private void initAndAdd(PsiComment comment) {
            if (this.buffer == null) {
                this.buffer = new ArrayList<PsiComment>();
            }
            this.buffer.add(comment);
        }
    }
}

