/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.intellij.lang.ASTNode;
import com.intellij.protobuf.ide.util.PbIcons;
import com.intellij.protobuf.lang.psi.PbPackageName;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.protobuf.lang.psi.impl.PbElementBase;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PbPackageNameMixin
extends PbElementBase
implements PbPackageName {
    PbPackageNameMixin(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public PbPackageName getQualifier() {
        return (PbPackageName)PsiTreeUtil.getChildOfType((PsiElement)this, PbPackageName.class);
    }

    @Override
    @Nullable
    public QualifiedName getQualifiedName() {
        return PbPsiImplUtil.getQualifiedName(this);
    }

    @Override
    @Nullable
    public PbSymbolOwner getSymbolOwner() {
        PbPackageName qualifier = this.getQualifier();
        return qualifier != null ? this.getQualifier() : this.getPbFile();
    }

    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    @NotNull
    public PsiElement getNameIdentifier() {
        PsiElement psiElement = this.findNotNullChildByType(ProtoTokenTypes.IDENTIFIER_LITERAL);
        if (psiElement == null) {
            PbPackageNameMixin.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public String getName() {
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            PbPackageNameMixin.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement identifier;
        ASTNode node;
        if (name == null) {
            PbPackageNameMixin.$$$reportNull$$$0(2);
        }
        if ((node = (identifier = this.getNameIdentifier()).getNode()) instanceof LeafElement) {
            ((LeafElement)node).replaceWithText(name);
            return this;
        }
        throw new IncorrectOperationException();
    }

    @Override
    @Nullable
    public QualifiedName getChildScope() {
        return this.getQualifiedName();
    }

    @Override
    @NotNull
    public Multimap<String, PbSymbol> getSymbolMap() {
        ImmutableMultimap<String, PbSymbol> immutableMultimap = this.getPbFile().getPackageSymbolMap(this.getQualifiedName());
        if (immutableMultimap == null) {
            PbPackageNameMixin.$$$reportNull$$$0(3);
        }
        return immutableMultimap;
    }

    public Icon getIcon(int flags) {
        return PbIcons.PACKAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/psi/impl/PbPackageNameMixin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/psi/impl/PbPackageNameMixin";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

