/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.protobuf.lang.descriptor.Descriptor;
import com.intellij.protobuf.lang.psi.PbExtensionName;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbOptionOwner;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.protobuf.lang.psi.SpecialOptionType;
import com.intellij.protobuf.lang.psi.impl.PbElementBase;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.lang.resolve.PbOptionNameReference;
import com.intellij.protobuf.lang.resolve.PbResolveResult;
import com.intellij.protobuf.lang.resolve.PbSymbolResolver;
import com.intellij.protobuf.lang.resolve.ResolveFilters;
import com.intellij.protobuf.lang.util.BuiltInType;
import com.intellij.protobuf.lang.util.ValueTester;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

abstract class PbOptionNameMixin
extends PbElementBase
implements PbOptionName {
    private static final Logger logger = Logger.getInstance(PbOptionNameMixin.class);

    PbOptionNameMixin(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public PbOptionName getQualifier() {
        return (PbOptionName)PsiTreeUtil.getChildOfType((PsiElement)this, PbOptionName.class);
    }

    @Override
    @Nullable
    public PbExtensionName getExtensionName() {
        return (PbExtensionName)PsiTreeUtil.getChildOfType((PsiElement)this, PbExtensionName.class);
    }

    @Override
    @Nullable
    public PsiElement getSymbol() {
        return this.findChildByType(ProtoTokenTypes.IDENTIFIER_LITERAL);
    }

    public PsiReference getReference() {
        if (this.getExtensionName() != null || this.isSpecial()) {
            return null;
        }
        return new PbOptionNameReference(this);
    }

    @Override
    @Nullable
    public PsiReference getEffectiveReference() {
        PbExtensionName extensionName = this.getExtensionName();
        if (extensionName != null) {
            return extensionName.getEffectiveReference();
        }
        return this.getReference();
    }

    @Override
    @Nullable
    public PbMessageType getQualifierType() {
        return (PbMessageType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getQualifierTypeNoCache(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private PbMessageType getQualifierTypeNoCache() {
        PbOptionName qualifier = this.getQualifier();
        if (qualifier != null) {
            return PbOptionNameMixin.getFieldType(PbOptionNameMixin.getQualifierField(qualifier));
        }
        return this.getDescriptorType();
    }

    @Override
    public boolean isSpecial() {
        return this.getSpecialType() != null;
    }

    @Override
    public SpecialOptionType getSpecialType() {
        PsiElement symbol = this.getSymbol();
        if (symbol != null) {
            PbOptionOwner owner = this.getOwner();
            for (SpecialOptionType type : SpecialOptionType.values()) {
                if (!type.isInstance(this, owner)) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public ValueTester getBuiltInValueTester() {
        BuiltInType type = this.getBuiltInType();
        if (type == null) {
            return null;
        }
        SpecialOptionType specialType = this.getSpecialType();
        if (specialType == SpecialOptionType.FIELD_DEFAULT) {
            return type.getValueTester(ValueTester.ValueTesterType.DEFAULT);
        }
        return type.getValueTester(ValueTester.ValueTesterType.OPTION);
    }

    @Override
    @Nullable
    public BuiltInType getBuiltInType() {
        SpecialOptionType specialType = this.getSpecialType();
        if (specialType == SpecialOptionType.FIELD_DEFAULT) {
            PbOptionOwner owner = this.getOwner();
            if (!(owner instanceof PbField)) {
                return null;
            }
            PbTypeName typeName = ((PbField)owner).getTypeName();
            if (typeName == null) {
                return null;
            }
            return typeName.getBuiltInType();
        }
        if (specialType == SpecialOptionType.FIELD_JSON_NAME) {
            return BuiltInType.STRING;
        }
        PsiReference ref = this.getEffectiveReference();
        if (ref == null) {
            return null;
        }
        PsiElement optionField = ref.resolve();
        if (!(optionField instanceof PbField)) {
            return null;
        }
        PbTypeName typeName = ((PbField)optionField).getTypeName();
        if (typeName == null) {
            return null;
        }
        return typeName.getBuiltInType();
    }

    @Override
    @Nullable
    public PbNamedTypeElement getNamedType() {
        PsiReference ref;
        PbTypeName typeName = null;
        SpecialOptionType specialType = this.getSpecialType();
        if (specialType == SpecialOptionType.FIELD_DEFAULT) {
            PbOptionOwner owner = this.getOwner();
            if (!(owner instanceof PbField)) {
                return null;
            }
            typeName = ((PbField)owner).getTypeName();
        } else if (specialType == null) {
            ref = this.getEffectiveReference();
            if (ref == null) {
                return null;
            }
            PsiElement optionField = ref.resolve();
            if (!(optionField instanceof PbField)) {
                return null;
            }
            typeName = ((PbField)optionField).getTypeName();
        }
        if (typeName != null) {
            ref = typeName.getEffectiveReference();
            if (ref == null) {
                return null;
            }
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PbNamedTypeElement) {
                return (PbNamedTypeElement)resolved;
            }
        }
        return null;
    }

    @Nullable
    private static PbMessageType getFieldType(PbField field) {
        if (field == null) {
            return null;
        }
        PbTypeName type = field.getTypeName();
        if (type == null) {
            return null;
        }
        return PbPsiUtil.resolveRefToType(type.getEffectiveReference(), PbMessageType.class);
    }

    @Nullable
    private PbMessageType getDescriptorType() {
        PbOptionOwner owner = this.getOwner();
        if (owner == null) {
            logger.error("PbOptionName has no PbOptionOwner: " + this);
            return null;
        }
        Descriptor descriptor = Descriptor.locate(this.getPbFile());
        if (descriptor == null) {
            return null;
        }
        return PbSymbolResolver.forFile(descriptor.getFile()).resolveName(owner.getDescriptorOptionsTypeName(descriptor), ResolveFilters.packageOrMessage()).stream().map(PbResolveResult::getElement).filter(element -> element instanceof PbMessageType).map(element -> (PbMessageType)element).findFirst().orElse(null);
    }

    @Nullable
    private static PbField getQualifierField(PbOptionName qualifier) {
        PsiReference ref = qualifier.getEffectiveReference();
        if (ref != null) {
            return PbPsiUtil.resolveRefToType(ref, PbField.class);
        }
        return null;
    }

    @Nullable
    private PbOptionOwner getOwner() {
        return PbPsiImplUtil.getOptionOwner(this);
    }
}

