/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.impl.PbElementFactory;
import com.intellij.protobuf.lang.psi.impl.PbFieldBase;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PbMapFieldMixin
extends PbFieldBase
implements PbMapField {
    PbMapFieldMixin(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public List<PbSymbol> getAdditionalSiblings() {
        PbMessageType mapEntry = this.createMapEntry(this.mapEntryName(this.getName()), this.getKeyType(), this.getValueType());
        if (mapEntry != null) {
            List<PbSymbol> list = Collections.singletonList(mapEntry);
            if (list == null) {
                PbMapFieldMixin.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<PbSymbol> list = Collections.emptyList();
        if (list == null) {
            PbMapFieldMixin.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public PbTypeName getTypeName() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        return ((PbElementFactory.TypeNameBuilder)PbElementFactory.getInstance((PsiFile)this.getPbFile()).typeNameBuilder().setName(this.mapEntryName(name)).setParent(this)).build();
    }

    @Override
    public PbField.CanonicalFieldLabel getCanonicalLabel() {
        return PbField.CanonicalFieldLabel.REPEATED;
    }

    private String mapEntryName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean capNext = true;
        for (int i = 0; i < fieldName.length(); ++i) {
            char curChar = fieldName.charAt(i);
            if (curChar == '_') {
                capNext = true;
                continue;
            }
            if (capNext) {
                if ('a' <= curChar && curChar <= 'z') {
                    result.append((char)(curChar - 97 + 65));
                } else {
                    result.append(curChar);
                }
                capNext = false;
                continue;
            }
            result.append(curChar);
        }
        result.append("Entry");
        return result.toString();
    }

    private PbMessageType createMapEntry(String entryName, PbTypeName keyType, PbTypeName valueType) {
        if (entryName == null) {
            return null;
        }
        boolean needsOptionalLabel = this.getPbFile().getSyntaxLevel() == SyntaxLevel.PROTO2;
        PbElementFactory factory = PbElementFactory.getInstance((PsiFile)this.getPbFile());
        PbElementFactory.MessageBuilder builder = ((PbElementFactory.MessageBuilder)((PbElementFactory.MessageBuilder)factory.messageBuilder().setName(entryName).setParent(this.getParent())).setNavigationElement(this)).addStatement(factory.optionBuilder().setName("map_entry").setValue(true).buildStatement());
        if (keyType != null) {
            PbElementFactory.FieldBuilder keyBuilder = (PbElementFactory.FieldBuilder)factory.fieldBuilder().setType(keyType.getReferenceString()).setName("key").setNumber(1).setNavigationElement(this.getKeyType());
            if (needsOptionalLabel) {
                keyBuilder.setLabel("optional");
            }
            builder.addStatement(keyBuilder.build());
        }
        if (valueType != null) {
            PbElementFactory.FieldBuilder valueBuilder = (PbElementFactory.FieldBuilder)factory.fieldBuilder().setType(valueType.getReferenceString()).setName("value").setNumber(2).setNavigationElement(this.getValueType());
            if (needsOptionalLabel) {
                valueBuilder.setLabel("optional");
            }
            builder.addStatement(valueBuilder.build());
        }
        return builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/lang/psi/impl/PbMapFieldMixin", "getAdditionalSiblings"));
    }
}

