/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.protobuf.ide.util.PbIcons;
import com.intellij.protobuf.lang.psi.PbFieldLabel;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbGroupOptionContainer;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbSimpleField;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.impl.PbElementFactory;
import com.intellij.protobuf.lang.psi.impl.PbOverridableElement;
import com.intellij.protobuf.lang.psi.impl.PbSimpleFieldImpl;
import com.intellij.protobuf.lang.psi.impl.PbStubbedSymbolOwnerBase;
import com.intellij.protobuf.lang.stub.PbGroupDefinitionStub;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PbGroupDefinitionMixin
extends PbStubbedSymbolOwnerBase<PbGroupDefinitionStub>
implements PbGroupDefinition {
    PbGroupDefinitionMixin(ASTNode node) {
        super(node);
    }

    PbGroupDefinitionMixin(PbGroupDefinitionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @NotNull
    public List<PbSymbol> getAdditionalSiblings() {
        PbSimpleField generatedField = this.getGeneratedField();
        if (generatedField != null) {
            List<PbSymbol> list = Collections.singletonList(generatedField);
            if (list == null) {
                PbGroupDefinitionMixin.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<PbSymbol> list = Collections.emptyList();
        if (list == null) {
            PbGroupDefinitionMixin.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public PbSimpleField getGeneratedField() {
        return (PbSimpleField)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.generateField(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private PbSimpleField generateField() {
        Long numberValue;
        String name = this.getName();
        PbNumberValue number = this.getFieldNumber();
        Long l = numberValue = number != null ? number.getLongValue() : null;
        if (name == null || numberValue == null || !number.isValidInt32()) {
            return null;
        }
        PbElementFactory factory = PbElementFactory.getInstance((PsiFile)this.getPbFile());
        PbElementFactory.FieldBuilder builder = ((PbElementFactory.FieldBuilder)((PbElementFactory.FieldBuilder)factory.fieldBuilder().setParent(this.getParent())).setNavigationElement(this)).setLabel(this.getDeclaredLabel()).setType(this.getName()).setName(name.toLowerCase()).setNumber(numberValue.intValue());
        PbGroupOptionContainer optionContainer = this.getGroupOptionContainer();
        if (optionContainer != null) {
            builder.setOptionText(optionContainer.getText());
        }
        return new GroupDefinitionField(builder.build());
    }

    public Icon getIcon(int flags) {
        return PbIcons.GROUP_FIELD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/lang/psi/impl/PbGroupDefinitionMixin", "getAdditionalSiblings"));
    }

    private class GroupDefinitionField
    extends PbSimpleFieldImpl {
        GroupDefinitionField(PbSimpleField field) {
            super(field.getNode());
            if (field instanceof PbOverridableElement) {
                ((PbOverridableElement)((Object)field)).copyOverridesTo(this);
            }
        }

        @Override
        @Nullable
        public PbFieldLabel getDeclaredLabel() {
            return PbGroupDefinitionMixin.this.getDeclaredLabel();
        }

        @Override
        @Nullable
        public PbNumberValue getFieldNumber() {
            return PbGroupDefinitionMixin.this.getFieldNumber();
        }

        @Override
        @NotNull
        public List<PbOptionExpression> getOptions() {
            PbGroupOptionContainer optionContainer = PbGroupDefinitionMixin.this.getGroupOptionContainer();
            if (optionContainer == null) {
                List<PbOptionExpression> list = Collections.emptyList();
                if (list == null) {
                    GroupDefinitionField.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<PbOptionExpression> options = optionContainer.getOptions();
            if (options == null) {
                List<PbOptionExpression> list = Collections.emptyList();
                if (list == null) {
                    GroupDefinitionField.$$$reportNull$$$0(1);
                }
                return list;
            }
            List<PbOptionExpression> list = options;
            if (list == null) {
                GroupDefinitionField.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/lang/psi/impl/PbGroupDefinitionMixin$GroupDefinitionField", "getOptions"));
        }
    }
}

