/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.protobuf.lang.PbFileType;
import com.intellij.protobuf.lang.PbLanguage;
import com.intellij.protobuf.lang.descriptor.Descriptor;
import com.intellij.protobuf.lang.descriptor.DescriptorOptionType;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbImportName;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.PbOptionStatement;
import com.intellij.protobuf.lang.psi.PbPackageName;
import com.intellij.protobuf.lang.psi.PbPackageStatement;
import com.intellij.protobuf.lang.psi.PbStatement;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.PbSyntaxStatement;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbFileImpl
extends PsiFileBase
implements PbFile {
    private static final Logger logger = Logger.getInstance(PbFileImpl.class);

    public PbFileImpl(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PbFileImpl.$$$reportNull$$$0(0);
        }
        super(viewProvider, (Language)PbLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        PbFileType pbFileType = PbFileType.INSTANCE;
        if (pbFileType == null) {
            PbFileImpl.$$$reportNull$$$0(1);
        }
        return pbFileType;
    }

    public String toString() {
        return "Protocol Buffer File";
    }

    @Override
    @Nullable
    public PbSyntaxStatement getSyntaxStatement() {
        return (PbSyntaxStatement)PsiTreeUtil.getChildOfType((PsiElement)this, PbSyntaxStatement.class);
    }

    @Override
    @Nullable
    public PbPackageStatement getPackageStatement() {
        return (PbPackageStatement)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)((PbPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)this, PbPackageStatement.class)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Override
    @NotNull
    public List<PbImportStatement> getImportStatements() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PbImportStatement.class), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            PbFileImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public SyntaxLevel getSyntaxLevel() {
        PbSyntaxStatement statement = this.getSyntaxStatement();
        SyntaxLevel level = null;
        if (statement != null) {
            level = statement.getSyntaxLevel();
        }
        SyntaxLevel syntaxLevel = level != null ? level : SyntaxLevel.PROTO2;
        if (syntaxLevel == null) {
            PbFileImpl.$$$reportNull$$$0(3);
        }
        return syntaxLevel;
    }

    @Override
    @NotNull
    public QualifiedName getPackageQualifiedName() {
        QualifiedName packageQualifiedName;
        PbPackageName packageName;
        PbPackageStatement packageStatement = this.getPackageStatement();
        if (packageStatement != null && (packageName = packageStatement.getPackageName()) != null && (packageQualifiedName = packageName.getQualifiedName()) != null) {
            QualifiedName qualifiedName = packageQualifiedName;
            if (qualifiedName == null) {
                PbFileImpl.$$$reportNull$$$0(4);
            }
            return qualifiedName;
        }
        QualifiedName qualifiedName = PbPsiUtil.EMPTY_QUALIFIED_NAME;
        if (qualifiedName == null) {
            PbFileImpl.$$$reportNull$$$0(5);
        }
        return qualifiedName;
    }

    @Override
    @Nullable
    public QualifiedName getChildScope() {
        return PbPsiUtil.EMPTY_QUALIFIED_NAME;
    }

    @Override
    public PbFile getPbFile() {
        return this;
    }

    @Override
    @NotNull
    public List<PbStatement> getStatements() {
        List<PbStatement> list = PbPsiImplUtil.getStatements(this);
        if (list == null) {
            PbFileImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PbOptionStatement> getOptionStatements() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PbOptionStatement.class);
        if (list == null) {
            PbFileImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public QualifiedName getDescriptorOptionsTypeName(Descriptor descriptor) {
        QualifiedName qualifiedName = DescriptorOptionType.FILE_OPTIONS.forDescriptor(descriptor);
        if (qualifiedName == null) {
            PbFileImpl.$$$reportNull$$$0(8);
        }
        return qualifiedName;
    }

    @Override
    @NotNull
    public Multimap<String, PbSymbol> getSymbolMap() {
        ImmutableMultimap<String, PbSymbol> immutableMultimap = this.getPackageSymbolMap(PbPsiUtil.EMPTY_QUALIFIED_NAME);
        if (immutableMultimap == null) {
            PbFileImpl.$$$reportNull$$$0(9);
        }
        return immutableMultimap;
    }

    @Override
    @NotNull
    public ImmutableMultimap<String, PbSymbol> getPackageSymbolMap(QualifiedName packageName) {
        QualifiedName declaredPackageName = this.getPackageQualifiedName();
        if (declaredPackageName.equals((Object)packageName)) {
            ImmutableMultimap<String, PbSymbol> immutableMultimap = PbPsiImplUtil.getCachedSymbolMap(this);
            if (immutableMultimap == null) {
                PbFileImpl.$$$reportNull$$$0(10);
            }
            return immutableMultimap;
        }
        if (declaredPackageName.matchesPrefix(packageName)) {
            PbPackageName packageElement = this.findPackageChildForName(packageName);
            if (packageElement == null) {
                logger.error(String.format("Failed to find a child package for name '%s' even though getPackageQualifiedName() returned '%s'", packageName, declaredPackageName));
                ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
                if (immutableListMultimap == null) {
                    PbFileImpl.$$$reportNull$$$0(11);
                }
                return immutableListMultimap;
            }
            String packageElementName = packageElement.getName();
            if (packageElementName == null) {
                ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
                if (immutableListMultimap == null) {
                    PbFileImpl.$$$reportNull$$$0(12);
                }
                return immutableListMultimap;
            }
            ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of((Object)packageElementName, (Object)packageElement);
            if (immutableListMultimap == null) {
                PbFileImpl.$$$reportNull$$$0(13);
            }
            return immutableListMultimap;
        }
        ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
        if (immutableListMultimap == null) {
            PbFileImpl.$$$reportNull$$$0(14);
        }
        return immutableListMultimap;
    }

    @Override
    @NotNull
    public PbSymbolOwner getPrimarySymbolOwner() {
        PbPackageStatement packageStatement = this.getPackageStatement();
        if (packageStatement == null) {
            PbFileImpl pbFileImpl = this;
            if (pbFileImpl == null) {
                PbFileImpl.$$$reportNull$$$0(15);
            }
            return pbFileImpl;
        }
        PbPackageName packageName = packageStatement.getPackageName();
        if (packageName == null) {
            PbFileImpl pbFileImpl = this;
            if (pbFileImpl == null) {
                PbFileImpl.$$$reportNull$$$0(16);
            }
            return pbFileImpl;
        }
        PbPackageName pbPackageName = packageName;
        if (pbPackageName == null) {
            PbFileImpl.$$$reportNull$$$0(17);
        }
        return pbPackageName;
    }

    @Override
    @NotNull
    public QualifiedName getExtensionOptionScope() {
        QualifiedName qualifiedName = this.getPackageQualifiedName();
        if (qualifiedName == null) {
            PbFileImpl.$$$reportNull$$$0(18);
        }
        return qualifiedName;
    }

    @Override
    @NotNull
    public ImmutableMultimap<QualifiedName, PbSymbol> getLocalQualifiedSymbolMap() {
        ImmutableMultimap immutableMultimap = (ImmutableMultimap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.computeLocalQualifiedSymbolMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (immutableMultimap == null) {
            PbFileImpl.$$$reportNull$$$0(19);
        }
        return immutableMultimap;
    }

    @Override
    @NotNull
    public ImmutableMultimap<QualifiedName, PbSymbol> getExportedQualifiedSymbolMap() {
        ImmutableMultimap immutableMultimap = (ImmutableMultimap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.computeExportedQualifiedSymbolMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (immutableMultimap == null) {
            PbFileImpl.$$$reportNull$$$0(20);
        }
        return immutableMultimap;
    }

    @Override
    @NotNull
    public ImmutableMultimap<QualifiedName, PbSymbol> getFullQualifiedSymbolMap() {
        ImmutableMultimap immutableMultimap = (ImmutableMultimap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.computeFullQualifiedSymbolMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (immutableMultimap == null) {
            PbFileImpl.$$$reportNull$$$0(21);
        }
        return immutableMultimap;
    }

    private ImmutableMultimap<QualifiedName, PbSymbol> computeLocalQualifiedSymbolMap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.addSymbolsRecursively(this, (ImmutableMultimap.Builder<QualifiedName, PbSymbol>)builder);
        return builder.build();
    }

    private void addSymbolsRecursively(PbSymbolOwner parent, ImmutableMultimap.Builder<QualifiedName, PbSymbol> builder) {
        for (PbSymbol symbol : parent.getSymbols()) {
            QualifiedName symbolQualifiedName = symbol.getQualifiedName();
            if (symbolQualifiedName != null) {
                builder.put((Object)symbolQualifiedName, (Object)symbol);
            }
            if (!(symbol instanceof PbSymbolOwner)) continue;
            this.addSymbolsRecursively((PbSymbolOwner)((Object)symbol), builder);
        }
    }

    private ImmutableMultimap<QualifiedName, PbSymbol> computeExportedQualifiedSymbolMap() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll(this.getLocalQualifiedSymbolMap());
        for (PbFile importedFile : this.getImportedFileList(false)) {
            builder.putAll(importedFile.getLocalQualifiedSymbolMap());
        }
        return builder.build();
    }

    private ImmutableMultimap<QualifiedName, PbSymbol> computeFullQualifiedSymbolMap() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll(this.getLocalQualifiedSymbolMap());
        for (PbFile importedFile : this.getImportedFileList(true)) {
            builder.putAll(importedFile.getLocalQualifiedSymbolMap());
        }
        return builder.build();
    }

    private PbPackageName findPackageChildForName(QualifiedName name) {
        PbPackageName lastChild = null;
        PbPackageStatement packageStatement = this.getPackageStatement();
        if (packageStatement == null) {
            return null;
        }
        for (PbPackageName currentPackage = packageStatement.getPackageName(); currentPackage != null && currentPackage.getQualifiedName() != null && currentPackage.getQualifiedName().matchesPrefix(name); currentPackage = currentPackage.getQualifier()) {
            if (currentPackage.getQualifiedName().equals((Object)name)) {
                return lastChild;
            }
            lastChild = currentPackage;
        }
        return name.getComponentCount() == 0 ? lastChild : null;
    }

    private List<PbFile> getImportedFileList(boolean includePrivate) {
        LinkedHashSet<PbFile> importedFiles = new LinkedHashSet<PbFile>();
        PbFileImpl.findImportsRecursively(this, importedFiles, includePrivate);
        return new ArrayList<PbFile>(importedFiles);
    }

    private static void findImportsRecursively(PbFile file, Collection<PbFile> imports, boolean includePrivate) {
        for (PbImportStatement pbImport : file.getImportStatements()) {
            PbFile importedFile;
            PsiElement possibleFile;
            PsiReference ref;
            PbImportName importName;
            if (!includePrivate && !pbImport.isPublic() || (importName = pbImport.getImportName()) == null || (ref = importName.getReference()) == null || !((possibleFile = ref.resolve()) instanceof PbFile) || imports.contains(importedFile = (PbFile)possibleFile)) continue;
            imports.add(importedFile);
            PbFileImpl.findImportsRecursively(importedFile, imports, false);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PbFileImpl.$$$reportNull$$$0(22);
        }
        if (state == null) {
            PbFileImpl.$$$reportNull$$$0(23);
        }
        if (place == null) {
            PbFileImpl.$$$reportNull$$$0(24);
        }
        for (PbStatement statement : this.getStatements()) {
            if (processor.execute((PsiElement)statement, state)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/psi/impl/PbFileImpl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/psi/impl/PbFileImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxLevel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionStatements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorOptionsTypeName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolMap";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageSymbolMap";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimarySymbolOwner";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionOptionScope";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalQualifiedSymbolMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedQualifiedSymbolMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullQualifiedSymbolMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

