/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.lang.PbParserDefinition;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbFieldLabel;
import com.intellij.protobuf.lang.psi.PbMessageBody;
import com.intellij.protobuf.lang.psi.PbMessageDefinition;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbOptionStatement;
import com.intellij.protobuf.lang.psi.PbSimpleField;
import com.intellij.protobuf.lang.psi.PbStatement;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.PbTypes;
import com.intellij.protobuf.lang.psi.impl.PbOverridableElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.QualifiedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PbElementFactory {
    private final PsiFile file;
    private final Project project;
    private final PsiManager manager;

    public static PbElementFactory getInstance(PsiFile file) {
        return new PbElementFactory(file);
    }

    private PbElementFactory(PsiFile file) {
        this.file = file;
        this.project = file.getProject();
        this.manager = file.getManager();
    }

    public TypeNameBuilder typeNameBuilder() {
        return new TypeNameBuilder();
    }

    FieldLabelBuilder fieldLabelBuilder() {
        return new FieldLabelBuilder();
    }

    OptionBuilder optionBuilder() {
        return new OptionBuilder();
    }

    MessageBuilder messageBuilder() {
        return new MessageBuilder();
    }

    FieldBuilder fieldBuilder() {
        return new FieldBuilder();
    }

    private PsiElement parseLight(IElementType type, CharSequence text) {
        PbParserDefinition parserDefinition = new PbParserDefinition();
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder((ParserDefinition)parserDefinition, parserDefinition.createLexer(this.project), text);
        LightPsiParser parser = (LightPsiParser)parserDefinition.createParser(this.project);
        parser.parseLight(type, builder);
        ASTNode node = builder.getTreeBuilt();
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.manager, null);
        holder.setOriginalFile(this.file);
        holder.getTreeElement().rawAddChildren((TreeElement)node);
        return node.getPsi();
    }

    private static void replacePlaceholders(List<? extends PsiElement> placeholders, List<? extends PsiElement> defined) {
        if (placeholders.size() != defined.size()) {
            throw new IllegalArgumentException(String.format("placeholder count does not match defined count: %d != %d", placeholders.size(), defined.size()));
        }
        for (int i = 0; i < defined.size(); ++i) {
            placeholders.get(i).replace(defined.get(i));
        }
    }

    class FieldBuilder
    extends AbstractBuilder<FieldBuilder> {
        private String label;
        private String type;
        private String name;
        private int number = 0;
        private String optionText;
        private final List<PbOptionExpression> options = new ArrayList<PbOptionExpression>();

        FieldBuilder() {
        }

        @Override
        public FieldBuilder getThis() {
            return this;
        }

        public FieldBuilder setLabel(PbFieldLabel label) {
            this.label = label != null ? label.getText() : null;
            return this;
        }

        public FieldBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public FieldBuilder setType(String type) {
            this.type = type;
            return this;
        }

        public FieldBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public FieldBuilder setNumber(int number) {
            this.number = number;
            return this;
        }

        public FieldBuilder setOptionText(String optionText) {
            this.optionText = optionText;
            return this;
        }

        public FieldBuilder addOption(PbOptionExpression option) {
            this.options.add(option);
            return this;
        }

        public PbSimpleField build() {
            if (this.type == null) {
                throw new IllegalStateException("type is missing");
            }
            if (this.name == null) {
                throw new IllegalStateException("name is missing");
            }
            if (this.number <= 0) {
                throw new IllegalStateException("number is missing");
            }
            if (this.optionText != null && !this.options.isEmpty()) {
                throw new IllegalArgumentException("setOptionText and addOption cannot be used together");
            }
            String labelPrefix = this.label != null ? this.label + " " : "";
            Object optionSuffix = "";
            if (this.optionText != null) {
                optionSuffix = " " + this.optionText;
            } else if (!this.options.isEmpty()) {
                optionSuffix = " [" + String.join((CharSequence)", ", Collections.nCopies(this.options.size(), "key=val")) + "]";
            }
            String text = String.format("%s%s %s = %d%s;", labelPrefix, this.type, this.name, this.number, optionSuffix);
            PbSimpleField element = (PbSimpleField)PbElementFactory.this.parseLight(PbTypes.SIMPLE_FIELD, text);
            this.updateCommonFields(element);
            if (!this.options.isEmpty()) {
                PbElementFactory.replacePlaceholders(element.getOptions(), this.options);
            }
            return element;
        }
    }

    class MessageBuilder
    extends AbstractBuilder<MessageBuilder> {
        private String name;
        private final List<PbStatement> members = new ArrayList<PbStatement>();

        MessageBuilder() {
        }

        @Override
        public MessageBuilder getThis() {
            return this;
        }

        public MessageBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public MessageBuilder addStatement(PbStatement statement) {
            this.members.add(statement);
            return this;
        }

        public PbMessageDefinition build() {
            if (this.name == null) {
                throw new IllegalStateException("name is missing");
            }
            String text = String.format("message %s {}", this.name);
            PbMessageDefinition element = (PbMessageDefinition)PbElementFactory.this.parseLight(PbTypes.MESSAGE_DEFINITION, text);
            this.updateCommonFields(element);
            PbMessageBody body = element.getBody();
            if (body == null) {
                throw new IllegalStateException("generated message has no body");
            }
            this.members.forEach(arg_0 -> ((PbMessageBody)body).add(arg_0));
            return element;
        }
    }

    class OptionBuilder
    extends AbstractBuilder<OptionBuilder> {
        String name;
        String value;

        OptionBuilder() {
        }

        @Override
        public OptionBuilder getThis() {
            return this;
        }

        public OptionBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public OptionBuilder setRawValue(String value) {
            this.value = value;
            return this;
        }

        public OptionBuilder setValue(String value) {
            this.value = "'" + value + "'";
            return this;
        }

        public OptionBuilder setValue(boolean value) {
            this.value = Boolean.toString(value);
            return this;
        }

        public OptionBuilder setValue(long value) {
            this.value = Long.toString(value);
            return this;
        }

        public OptionBuilder setValue(double value) {
            this.value = Double.toString(value);
            return this;
        }

        public PbOptionExpression buildExpression() {
            this.validate();
            String text = String.format("%s = %s", this.name, this.value);
            PbOptionExpression element = (PbOptionExpression)PbElementFactory.this.parseLight(PbTypes.OPTION_EXPRESSION, text);
            this.updateCommonFields(element);
            return element;
        }

        public PbOptionStatement buildStatement() {
            this.validate();
            String text = String.format("option %s = %s;", this.name, this.value);
            PbOptionStatement element = (PbOptionStatement)PbElementFactory.this.parseLight(PbTypes.OPTION_STATEMENT, text);
            this.updateCommonFields(element);
            return element;
        }

        private void validate() {
            if (this.name == null) {
                throw new IllegalStateException("name is missing");
            }
            if (this.value == null) {
                throw new IllegalStateException("value is missing");
            }
        }
    }

    class FieldLabelBuilder
    extends AbstractBuilder<FieldLabelBuilder> {
        private String label = null;

        FieldLabelBuilder() {
        }

        @Override
        FieldLabelBuilder getThis() {
            return this;
        }

        public FieldLabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public PbFieldLabel build() {
            if (this.label == null) {
                throw new IllegalStateException("label is missing");
            }
            PbFieldLabel element = (PbFieldLabel)PbElementFactory.this.parseLight(PbTypes.FIELD_LABEL, this.label);
            this.updateCommonFields(element);
            return element;
        }
    }

    public class TypeNameBuilder
    extends AbstractBuilder<TypeNameBuilder> {
        private String name = null;

        @Override
        TypeNameBuilder getThis() {
            return this;
        }

        public TypeNameBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public TypeNameBuilder setName(QualifiedName name) {
            this.name = name.toString();
            return this;
        }

        public PbTypeName build() {
            if (this.name == null) {
                throw new IllegalStateException("name is missing");
            }
            PbTypeName element = (PbTypeName)PbElementFactory.this.parseLight(PbTypes.TYPE_NAME, this.name);
            this.updateCommonFields(element);
            return element;
        }
    }

    static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        private PsiElement parent = null;
        private PsiElement navigationElement = null;
        private TextRange textRange = null;

        AbstractBuilder() {
        }

        abstract T getThis();

        public T setParent(PsiElement parent) {
            this.parent = parent;
            return this.getThis();
        }

        public T setNavigationElement(PsiElement navigationElement) {
            this.navigationElement = navigationElement;
            return this.getThis();
        }

        public T setTextRange(TextRange textRange) {
            this.textRange = textRange;
            return this.getThis();
        }

        void updateCommonFields(PbElement element) {
            if (!(element instanceof PbOverridableElement)) {
                throw new IllegalArgumentException("element must extend PbOverridableElement");
            }
            this.updateCommonFields((PbOverridableElement)element);
        }

        void updateCommonFields(PbOverridableElement element) {
            if (this.parent != null) {
                element.setParentOverride(this.parent);
            }
            if (this.navigationElement != null) {
                element.setNavigationElementOverride(this.navigationElement);
            }
            if (this.textRange != null) {
                element.setTextRangeOverride(this.textRange);
            }
        }
    }
}

