/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi;

import com.google.common.primitives.UnsignedLong;
import com.intellij.protobuf.lang.psi.ProtoLiteral;
import com.intellij.protobuf.lang.psi.ProtoNumberValueUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public interface ProtoNumberValue
extends ProtoLiteral {
    public PsiElement getNumberElement();

    @Nullable
    public SourceType getSourceType();

    @Nullable
    default public IntegerFormat getIntegerFormat() {
        if (this.getSourceType() == SourceType.INTEGER) {
            PsiElement numberElement = this.getNumberElement();
            if (numberElement == null) {
                return null;
            }
            String numberText = numberElement.getText();
            int radix = ProtoNumberValueUtil.getRadix(numberText);
            switch (radix) {
                case 8: {
                    return IntegerFormat.OCT;
                }
                case 10: {
                    return IntegerFormat.DEC;
                }
                case 16: {
                    return IntegerFormat.HEX;
                }
            }
            return null;
        }
        return null;
    }

    public boolean isNegative();

    @Override
    @Nullable
    default public Object getValue() {
        return this.getNumber();
    }

    @Nullable
    default public Long getLongValue() {
        PsiElement numberElement = this.getNumberElement();
        if (numberElement == null) {
            return null;
        }
        if (this.getSourceType() == SourceType.INTEGER) {
            String numberText = numberElement.getText();
            String negativePrefix = this.isNegative() ? "-" : "";
            int radix = ProtoNumberValueUtil.getRadix(numberText);
            numberText = ProtoNumberValueUtil.trimRadixPrefix(numberText, radix);
            try {
                return Long.parseLong(negativePrefix + numberText, radix);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    default public UnsignedLong getUnsignedLongValue() {
        if (this.isNegative()) {
            return null;
        }
        return this.getUnsignedLongComponent();
    }

    @Nullable
    default public UnsignedLong getUnsignedLongComponent() {
        PsiElement numberElement = this.getNumberElement();
        if (numberElement == null) {
            return null;
        }
        if (this.getSourceType() == SourceType.INTEGER) {
            String numberText = numberElement.getText();
            int radix = ProtoNumberValueUtil.getRadix(numberText);
            numberText = ProtoNumberValueUtil.trimRadixPrefix(numberText, radix);
            try {
                return UnsignedLong.valueOf((String)numberText, (int)radix);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    default public Double getDoubleValue() {
        SourceType sourceType = this.getSourceType();
        if (sourceType == null) {
            return null;
        }
        switch (sourceType) {
            case FLOAT: {
                PsiElement numberElement = this.getNumberElement();
                if (numberElement == null) {
                    return null;
                }
                String numberText = numberElement.getText();
                String negativePrefix = this.isNegative() ? "-" : "";
                try {
                    return Double.parseDouble(negativePrefix + numberText);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case INF: {
                return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            case NAN: {
                return Double.NaN;
            }
        }
        return null;
    }

    @Nullable
    default public Number getNumber() {
        SourceType sourceType = this.getSourceType();
        if (sourceType != null) {
            switch (this.getSourceType()) {
                case FLOAT: 
                case INF: 
                case NAN: {
                    return this.getDoubleValue();
                }
                case INTEGER: {
                    Long longValue = this.getLongValue();
                    return longValue != null ? longValue : this.getUnsignedLongValue();
                }
            }
        }
        return null;
    }

    default public boolean isValidDouble() {
        return this.getDoubleValue() != null;
    }

    default public boolean isValidInt32() {
        Long value = this.getLongValue();
        return value != null && value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    default public boolean isValidUint32() {
        if (this.isNegative()) {
            return false;
        }
        Long value = this.getLongValue();
        return value != null && value >= 0L && value <= 0xFFFFFFFFL;
    }

    default public boolean isValidInt64() {
        return this.getLongValue() != null;
    }

    default public boolean isValidUint64() {
        return this.getUnsignedLongValue() != null;
    }

    default public boolean isValidInt65() {
        return this.getUnsignedLongComponent() != null;
    }

    public static enum IntegerFormat {
        OCT,
        DEC,
        HEX;

    }

    public static enum SourceType {
        INTEGER,
        FLOAT,
        INF,
        NAN;

    }
}

