/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi;

import com.intellij.protobuf.lang.psi.PbMessageBody;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbReservedStatement;
import com.intellij.protobuf.lang.psi.PbStringValue;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;

public interface PbMessageType
extends PbNamedTypeElement,
PbSymbolOwner {
    public PbMessageBody getBody();

    default public boolean isMessageSet() {
        PbMessageBody body = this.getBody();
        if (body == null) {
            return false;
        }
        return Boolean.TRUE.equals(PbPsiUtil.getBooleanDescriptorOption(body, "message_set_wire_format"));
    }

    default public boolean isReservedFieldName(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        PbMessageBody body = this.getBody();
        if (body == null) {
            return false;
        }
        for (PbReservedStatement reservedStatement : body.getReservedStatementList()) {
            for (PbStringValue reservedName : reservedStatement.getStringValueList()) {
                if (!fieldName.equals(reservedName.getAsString())) continue;
                return true;
            }
        }
        return false;
    }
}

