/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbOptionOwner;
import com.intellij.protobuf.lang.psi.SpecialOptionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.EnumMap;
import java.util.Map;

public class SpecialOptionTracker {
    private static final SpecialOptionTracker EMPTY = new SpecialOptionTracker();
    private final Map<SpecialOptionType, PbOptionName> firstOccurrences;

    private SpecialOptionTracker() {
        this.firstOccurrences = ImmutableMap.of();
    }

    private SpecialOptionTracker(PbOptionOwner owner) {
        this.firstOccurrences = new EnumMap<SpecialOptionType, PbOptionName>(SpecialOptionType.class);
        for (PbOptionExpression option : owner.getOptions()) {
            SpecialOptionType specialType = option.getOptionName().getSpecialType();
            if (specialType == null || this.firstOccurrences.containsKey((Object)specialType)) continue;
            this.firstOccurrences.put(specialType, option.getOptionName());
        }
    }

    static SpecialOptionTracker forOptionOwner(PbOptionOwner owner) {
        if (!(owner instanceof PbField)) {
            return EMPTY;
        }
        return (SpecialOptionTracker)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create((Object)new SpecialOptionTracker(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    void annotateOptionName(PbOptionName name, AnnotationHolder holder) {
        SpecialOptionType specialType = name.getSpecialType();
        if (specialType == null) {
            return;
        }
        PbOptionName firstOccurrence = this.firstOccurrences.get((Object)specialType);
        if (firstOccurrence == null || name.equals(firstOccurrence)) {
            return;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("special.option.multiple.times", name.getText())).range((PsiElement)name).create();
    }
}

