/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.descriptor.Descriptor;
import com.intellij.protobuf.lang.descriptor.DescriptorOptionType;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbExtendDefinition;
import com.intellij.protobuf.lang.psi.PbExtensionsStatement;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFieldLabel;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbIdentifierValue;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.PbMessageTypeName;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.PbVisitor;
import com.intellij.protobuf.lang.psi.ProtoBooleanValue;
import com.intellij.protobuf.lang.psi.SpecialOptionType;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import org.jetbrains.annotations.NotNull;

public class Proto3Annotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        if (element == null) {
            Proto3Annotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            Proto3Annotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PbElement) || ((PbElement)element).getPbFile().getSyntaxLevel() != SyntaxLevel.PROTO3) {
            return;
        }
        element.accept((PsiElementVisitor)new PbVisitor(){

            @Override
            public void visitEnumValue(@NotNull PbEnumValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                Proto3Annotator.annotateEnumValue(value, holder);
            }

            @Override
            public void visitExtendDefinition(@NotNull PbExtendDefinition extendDefinition) {
                if (extendDefinition == null) {
                    1.$$$reportNull$$$0(1);
                }
                Proto3Annotator.annotateExtendDefinition(extendDefinition, holder);
            }

            @Override
            public void visitExtensionsStatement(@NotNull PbExtensionsStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                Proto3Annotator.annotateExtensionsStatement(statement, holder);
            }

            @Override
            public void visitField(@NotNull PbField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(3);
                }
                Proto3Annotator.annotateField(field, holder);
            }

            @Override
            public void visitImportStatement(@NotNull PbImportStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(4);
                }
                Proto3Annotator.annotateImportStatement(statement, holder);
            }

            @Override
            public void visitGroupDefinition(@NotNull PbGroupDefinition group) {
                if (group == null) {
                    1.$$$reportNull$$$0(5);
                }
                Proto3Annotator.annotateGroupDefinition(group, holder);
            }

            @Override
            public void visitOptionExpression(@NotNull PbOptionExpression option) {
                if (option == null) {
                    1.$$$reportNull$$$0(6);
                }
                Proto3Annotator.annotateOptionExpression(option, holder);
            }

            @Override
            public void visitOptionName(@NotNull PbOptionName name) {
                if (name == null) {
                    1.$$$reportNull$$$0(7);
                }
                Proto3Annotator.annotateOptionName(name, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extendDefinition";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "option";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/lang/annotation/Proto3Annotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEnumValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExtendDefinition";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExtensionsStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitImportStatement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitGroupDefinition";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOptionExpression";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOptionName";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void annotateEnumValue(PbEnumValue value, AnnotationHolder holder) {
        PbEnumDefinition enumDefinition = (PbEnumDefinition)PsiTreeUtil.getParentOfType((PsiElement)value, PbEnumDefinition.class);
        if (enumDefinition == null) {
            return;
        }
        PbEnumValue firstValue = enumDefinition.getEnumValues().stream().findFirst().orElse(null);
        if (!value.equals(firstValue)) {
            return;
        }
        PbNumberValue numberValue = value.getNumberValue();
        if (numberValue == null) {
            return;
        }
        Long enumNumber = numberValue.getLongValue();
        if (enumNumber != null && enumNumber != 0L) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.first.enum.value.zero", new Object[0])).range((PsiElement)value).create();
        }
    }

    private static void annotateExtendDefinition(PbExtendDefinition extendDefinition, AnnotationHolder holder) {
        Descriptor descriptor = Descriptor.locate(extendDefinition.getPbFile());
        if (descriptor == null) {
            return;
        }
        PbMessageTypeName extendee = extendDefinition.getTypeName();
        if (extendee == null) {
            return;
        }
        PbSymbol resolved = PbPsiUtil.resolveRefToType(extendee.getEffectiveReference(), PbSymbol.class);
        if (resolved == null) {
            return;
        }
        QualifiedName extendeeQualifiedName = resolved.getQualifiedName();
        if (extendeeQualifiedName == null) {
            return;
        }
        for (DescriptorOptionType optionType : DescriptorOptionType.values()) {
            if (!extendeeQualifiedName.equals((Object)optionType.forDescriptor(descriptor))) continue;
            return;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.extensions", new Object[0])).range(extendee.getSymbolPath().getSymbol()).create();
    }

    private static void annotateExtensionsStatement(PbExtensionsStatement statement, AnnotationHolder holder) {
        holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.extension.ranges", new Object[0])).range((PsiElement)statement).create();
    }

    private static void annotateField(PbField field, AnnotationHolder holder) {
        PbFile definingFile;
        PbNamedTypeElement enumDef;
        PbTypeName fieldType;
        String convertedName;
        Multimap<String, PbField> fieldNameMap;
        PbFieldLabel label = field.getDeclaredLabel();
        if (label != null && "required".equals(label.getText())) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.required.fields", new Object[0])).range((PsiElement)label).create();
        }
        PsiElement nameIdentifier = field.getNameIdentifier();
        PbSymbolOwner message = field.getSymbolOwner();
        if (nameIdentifier != null && message != null && (fieldNameMap = Proto3Annotator.getProto3NameToFieldMap(message)).get((Object)(convertedName = Proto3Annotator.toLowerWithoutUnderscores(nameIdentifier.getText()))).size() > 1) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.field.name.uniqueness", new Object[0])).range(nameIdentifier).create();
        }
        if ((fieldType = field.getTypeName()) != null && (enumDef = (PbNamedTypeElement)PbPsiUtil.resolveRefToType(fieldType.getEffectiveReference(), PbEnumDefinition.class)) != null && (definingFile = enumDef.getPbFile()).getSyntaxLevel() != SyntaxLevel.PROTO3) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.enums", new Object[0])).range(fieldType.getSymbolPath().getSymbol()).create();
        }
    }

    private static void annotateGroupDefinition(PbGroupDefinition group, AnnotationHolder holder) {
        holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.group.fields", new Object[0])).range((PsiElement)group).create();
    }

    private static void annotateImportStatement(PbImportStatement statement, AnnotationHolder holder) {
        PsiElement label = statement.getImportLabel();
        if (label != null && statement.isWeak()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.weak.imports", new Object[0])).range(label).create();
        }
    }

    private static void annotateOptionExpression(PbOptionExpression option, AnnotationHolder holder) {
        if (option.getOptionName().getSpecialType() == SpecialOptionType.FIELD_DEFAULT) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.default.values", new Object[0])).range((PsiElement)option).create();
        }
    }

    private static void annotateOptionName(PbOptionName optionName, AnnotationHolder holder) {
        ProtoBooleanValue booleanValue;
        PbOptionExpression optionExpression = (PbOptionExpression)PsiTreeUtil.getParentOfType((PsiElement)optionName, PbOptionExpression.class);
        if (optionExpression == null) {
            return;
        }
        if (PbPsiUtil.isDescriptorOption(optionExpression, "cc_api_compatibility").booleanValue()) {
            PbIdentifierValue identifierValue = optionExpression.getIdentifierValue();
            if (identifierValue == null) {
                return;
            }
            PbEnumValue enumValue = PbPsiUtil.resolveRefToType(identifierValue.getReference(), PbEnumValue.class);
            if (enumValue == null) {
                return;
            }
            if (!"NO_COMPATIBILITY".equals(enumValue.getName())) {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.cc_api_compatibility", new Object[0])).range((PsiElement)optionName).create();
            }
        } else if (PbPsiUtil.isDescriptorOption(optionExpression, "message_set_wire_format").booleanValue() && (booleanValue = optionExpression.getBooleanValue()) != null && Boolean.TRUE.equals(booleanValue.getBooleanValue())) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto3.messageset", new Object[0])).range((PsiElement)optionName).create();
        }
    }

    private static Multimap<String, PbField> getProto3NameToFieldMap(PbSymbolOwner message) {
        return (Multimap)CachedValuesManager.getCachedValue((PsiElement)message, () -> {
            ArrayListMultimap messageFieldNameMap = ArrayListMultimap.create();
            for (PbField field : message.getSymbols(PbField.class)) {
                String fieldName = field.getName();
                if (fieldName == null) continue;
                messageFieldNameMap.put((Object)Proto3Annotator.toLowerWithoutUnderscores(fieldName), (Object)field);
            }
            return CachedValueProvider.Result.create((Object)messageFieldNameMap, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static String toLowerWithoutUnderscores(String name) {
        StringBuilder newName = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') continue;
            if (c >= 'A' && c <= 'Z') {
                newName.append((char)(c - 65 + 97));
                continue;
            }
            newName.append(c);
        }
        return newName.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/lang/annotation/Proto3Annotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

