/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbEnumBody;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumReservedRange;
import com.intellij.protobuf.lang.psi.PbEnumReservedStatement;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbStringValue;
import com.intellij.protobuf.lang.psi.ProtoBooleanValue;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class EnumTracker {
    private static final String ALLOW_ALIAS = "allow_alias";
    private final Multimap<PbElement, ProblemAnnotation> queuedAnnotations = ArrayListMultimap.create();

    EnumTracker() {
    }

    static void annotateEnumValue(PbEnumValue value, AnnotationHolder holder) {
        EnumTracker.annotateElement(value, holder);
    }

    static void annotateReservedStatement(PbEnumReservedStatement reservedStatement, AnnotationHolder holder) {
        EnumTracker.annotateElement(reservedStatement, holder);
    }

    static void annotateOptionExpression(PbOptionExpression optionExpression, AnnotationHolder holder) {
        EnumTracker.annotateElement(optionExpression, holder);
    }

    private static void annotateElement(PbElement element, AnnotationHolder holder) {
        PbEnumDefinition enumDefinition = (PbEnumDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, PbEnumDefinition.class);
        if (enumDefinition == null) {
            return;
        }
        EnumTracker tracker = EnumTracker.getTracker(enumDefinition);
        Collection problems = tracker.queuedAnnotations.get((Object)element);
        for (ProblemAnnotation problem : problems) {
            holder.newAnnotation(HighlightSeverity.ERROR, problem.message).range(problem.annotationElement).create();
        }
    }

    private static EnumTracker getTracker(PbEnumDefinition enumDefinition) {
        return (EnumTracker)CachedValuesManager.getCachedValue((PsiElement)enumDefinition, () -> {
            EnumTracker tracker = new EnumTracker();
            tracker.trackProblems(enumDefinition);
            return CachedValueProvider.Result.create((Object)tracker, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private void trackProblems(PbEnumDefinition enumDefinition) {
        new ProblemsVisitor().visit(enumDefinition);
    }

    private void queueError(PbElement element, PsiElement annotationElement, @InspectionMessage String message) {
        this.queuedAnnotations.put((Object)element, (Object)new ProblemAnnotation(annotationElement, message));
    }

    private static boolean valuesAreAliases(PbEnumValue first, PbEnumValue second) {
        Long secondLong;
        PbNumberValue firstNumber = first.getNumberValue();
        PbNumberValue secondNumber = second.getNumberValue();
        Long firstLong = firstNumber != null ? firstNumber.getLongValue() : null;
        Long l = secondLong = secondNumber != null ? secondNumber.getLongValue() : null;
        if (firstLong == null || secondLong == null) {
            return false;
        }
        return firstLong.equals(secondLong);
    }

    private static boolean allowsAliases(PbEnumDefinition enumDefinition) {
        PbEnumBody body = enumDefinition.getBody();
        if (body == null) {
            return false;
        }
        return Boolean.TRUE.equals(PbPsiUtil.getBooleanDescriptorOption(body, ALLOW_ALIAS));
    }

    private static String getCanonicalName(String enumName, String valueName) {
        if (enumName == null) {
            return valueName;
        }
        String withPrefixStripped = EnumTracker.stripPrefix(enumName, valueName);
        return EnumTracker.toPascalCase(withPrefixStripped);
    }

    private static String stripPrefix(String enumName, String valueName) {
        int i = 0;
        int j = 0;
        while (i < valueName.length() && j < enumName.length()) {
            if (valueName.charAt(i) == '_') {
                ++i;
                continue;
            }
            if (enumName.charAt(j) == '_') {
                ++j;
                continue;
            }
            if (Character.toLowerCase(valueName.charAt(i++)) == Character.toLowerCase(enumName.charAt(j++))) continue;
            return valueName;
        }
        if (j < enumName.length()) {
            return valueName;
        }
        while (i < valueName.length() && valueName.charAt(i) == '_') {
            ++i;
        }
        if (i == valueName.length()) {
            return valueName;
        }
        return valueName.substring(i);
    }

    private static String toPascalCase(String input) {
        boolean nextUpper = true;
        StringBuilder result = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '_') {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                result.append(Character.toUpperCase(c));
            } else {
                result.append(Character.toLowerCase(c));
            }
            nextUpper = false;
        }
        return result.toString();
    }

    private final class ProblemsVisitor {
        private final RangeSet<Integer> reservedNumbers = TreeRangeSet.create();
        private final Set<String> reservedNames = new HashSet<String>();
        private final Map<Integer, String> numberToName = new HashMap<Integer, String>();
        private final Map<String, PbEnumValue> canonicalNameToValue = new HashMap<String, PbEnumValue>();
        private boolean hasAliases = false;

        private ProblemsVisitor() {
        }

        void visit(PbEnumDefinition enumDefinition) {
            this.visitReserved(enumDefinition);
            this.visitValues(enumDefinition);
            this.visitOptions(enumDefinition);
        }

        private void visitReserved(PbEnumDefinition enumDefinition) {
            PbEnumBody body = enumDefinition.getBody();
            if (body == null) {
                return;
            }
            for (PbEnumReservedStatement reservedStatement : body.getEnumReservedStatementList()) {
                for (PbEnumReservedRange reservedRange : reservedStatement.getEnumReservedRangeList()) {
                    this.visitReservedRange(reservedStatement, reservedRange);
                }
                for (PbStringValue reservedName : reservedStatement.getStringValueList()) {
                    this.visitReservedName(reservedStatement, reservedName);
                }
            }
        }

        private void visitValues(PbEnumDefinition enumDefinition) {
            for (PbEnumValue value : enumDefinition.getEnumValues()) {
                PbNumberValue numberValue;
                String name = value.getName();
                if (name != null) {
                    this.visitEnumValueName(enumDefinition, value, name);
                }
                if ((numberValue = value.getNumberValue()) == null) continue;
                this.visitEnumValueNumber(enumDefinition, value, name, numberValue);
            }
        }

        private void visitOptions(PbEnumDefinition enumDefinition) {
            PbEnumBody body = enumDefinition.getBody();
            if (body == null) {
                return;
            }
            for (PbOptionExpression option : body.getOptions()) {
                ProtoBooleanValue booleanValue;
                Boolean aliasesAllowed;
                if (!EnumTracker.ALLOW_ALIAS.equals(option.getOptionName().getText()) || (aliasesAllowed = (booleanValue = option.getBooleanValue()) != null ? booleanValue.getBooleanValue() : null) == null) continue;
                if (aliasesAllowed.booleanValue()) {
                    if (this.hasAliases) continue;
                    EnumTracker.this.queueError(option, option, PbLangBundle.message("enum.allow.alias.unnecessary", new Object[0]));
                    continue;
                }
                EnumTracker.this.queueError(option, option, PbLangBundle.message("enum.allow.alias.no.effect", new Object[0]));
            }
        }

        private void visitReservedRange(PbEnumReservedStatement reservedStatement, PbEnumReservedRange reservedRange) {
            Range newRange;
            Optional<Range<Integer>> overlappingRange;
            Long from = reservedRange.getFrom();
            if (from == null) {
                return;
            }
            Integer fromInt = from.intValue();
            Long to = reservedRange.getTo();
            Integer toInt = to != null ? to.intValue() : fromInt.intValue();
            if (to != null && toInt <= fromInt) {
                EnumTracker.this.queueError(reservedStatement, reservedRange, PbLangBundle.message("enum.reserved.end.greater.than.start", new Object[0]));
            }
            if ((overlappingRange = this.findPreviousOverlappingReservedRange((Range<Integer>)(newRange = Range.closed((Comparable)fromInt, (Comparable)toInt)))).isPresent()) {
                EnumTracker.this.queueError(reservedStatement, reservedRange, PbLangBundle.message("enum.reserved.range.overlaps.existing", newRange.lowerEndpoint(), newRange.upperEndpoint(), overlappingRange.get().lowerEndpoint(), overlappingRange.get().upperEndpoint()));
                return;
            }
            this.reservedNumbers.add(newRange);
        }

        private Optional<Range<Integer>> findPreviousOverlappingReservedRange(Range<Integer> newRange) {
            RangeSet intersection = this.reservedNumbers.subRangeSet(newRange);
            if (intersection.isEmpty()) {
                return Optional.empty();
            }
            return this.reservedNumbers.asRanges().stream().filter(range -> range.isConnected(newRange)).findFirst();
        }

        private void visitReservedName(PbEnumReservedStatement reservedStatement, PbStringValue reservedName) {
            String name = reservedName.getAsString();
            if (!this.reservedNames.add(name)) {
                EnumTracker.this.queueError(reservedStatement, reservedName, PbLangBundle.message("enum.reserved.name.multiple.times", name));
            }
        }

        private void visitEnumValueNumber(PbEnumDefinition enumDefinition, PbEnumValue value, String name, PbNumberValue valueNumber) {
            if (!valueNumber.isValidInt32()) {
                EnumTracker.this.queueError(value, valueNumber, PbLangBundle.message("integer.value.out.of.range", new Object[0]));
                return;
            }
            Long numberAsLong = valueNumber.getLongValue();
            Preconditions.checkNotNull((Object)numberAsLong);
            int number = numberAsLong.intValue();
            if (this.numberToName.containsKey(number) && !EnumTracker.allowsAliases(enumDefinition)) {
                String earlierValue = this.numberToName.get(number);
                EnumTracker.this.queueError(value, valueNumber, PbLangBundle.message("enum.number.already.used", number, earlierValue));
            } else if (this.reservedNumbers.contains((Comparable)Integer.valueOf(number))) {
                EnumTracker.this.queueError(value, valueNumber, PbLangBundle.message("enum.uses.reserved.number", name, number));
            }
            if (this.numberToName.containsKey(number)) {
                this.hasAliases = true;
            } else {
                this.numberToName.put(number, name);
            }
        }

        private void visitEnumValueName(PbEnumDefinition enumDefinition, PbEnumValue value, String name) {
            PbEnumValue prevValue;
            String canonicalName = EnumTracker.getCanonicalName(enumDefinition.getName(), name);
            if (this.reservedNames.contains(name)) {
                EnumTracker.this.queueError(value, value.getNameIdentifier(), PbLangBundle.message("enum.uses.reserved.name", name));
            } else if (this.canonicalNameToValue.containsKey(canonicalName) && !EnumTracker.valuesAreAliases(value, prevValue = this.canonicalNameToValue.get(canonicalName))) {
                EnumTracker.this.queueError(value, value.getNameIdentifier(), PbLangBundle.message("enum.canonical.name.conflict", name, prevValue.getName(), canonicalName));
            }
            this.canonicalNameToValue.putIfAbsent(canonicalName, value);
        }
    }

    private static class ProblemAnnotation {
        final PsiElement annotationElement;
        final @InspectionMessage String message;

        ProblemAnnotation(PsiElement annotationElement, @InspectionMessage String message) {
            this.annotationElement = annotationElement;
            this.message = message;
        }
    }
}

