/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.names;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.intellij.protobuf.jvm.PbJavaGotoDeclarationContext;
import com.intellij.protobuf.jvm.names.NameGenerator;
import com.intellij.protobuf.jvm.names.NameMatcher;
import com.intellij.protobuf.jvm.names.NameUtils;
import com.intellij.protobuf.jvm.names.Proto2DefinitionClassNames;
import com.intellij.protobuf.jvm.names.Proto2NameMatcher;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.lang.util.BuiltInType;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Proto2NameGenerator
implements NameGenerator {
    private static final String CLASS_PREFIX = ".";
    private final Proto2DefinitionClassNames proto2DefinitionClassNames;

    Proto2NameGenerator(PbFile file, String javaPackage, String outerClassName, boolean isMultipleFiles) {
        this.proto2DefinitionClassNames = new Proto2DefinitionClassNames(file, file.getPackageQualifiedName(), javaPackage, javaPackage, CLASS_PREFIX, outerClassName, isMultipleFiles);
    }

    @Override
    public Set<String> outerClassNames() {
        return this.proto2DefinitionClassNames.outerClassNames(this);
    }

    @Override
    public Set<String> messageClassNames(PbMessageType messageType) {
        String baseName = this.proto2DefinitionClassNames.messageClassName(messageType);
        return baseName != null ? ImmutableSet.of((Object)baseName, (Object)(baseName + "OrBuilder")) : ImmutableSet.of();
    }

    private static String fieldConstantName(String fieldName) {
        return Ascii.toUpperCase((String)fieldName) + "_FIELD_NUMBER";
    }

    @Override
    public Set<String> fieldMemberNames(PbField field) {
        if (field.getName() == null) {
            return ImmutableSet.of();
        }
        String fieldName = NameGenerator.fieldName(field);
        ImmutableSet.Builder fieldNames = ImmutableSet.builder();
        String capitalCamelName = NameUtils.underscoreToCapitalizedCamelCase(fieldName);
        String messageQualifier = "";
        String builderQualifier = "Builder.";
        if (field.isRepeated()) {
            if (field instanceof PbMapField) {
                for (FieldFormat fmt : MapFields.IMMUTABLE_FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(messageQualifier, capitalCamelName));
                    fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
                }
                for (FieldFormat fmt : MapFields.MUTABLE_FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
                }
            } else {
                BuiltInType builtInType;
                for (FieldFormat fmt : RepeatedFields.IMMUTABLE_FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(messageQualifier, capitalCamelName));
                    fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
                }
                for (FieldFormat fmt : RepeatedFields.MUTABLE_FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
                }
                BuiltInType builtInType2 = builtInType = field.getTypeName() != null ? field.getTypeName().getBuiltInType() : null;
                if (builtInType != null && builtInType.equals((Object)BuiltInType.STRING)) {
                    fieldNames.add((Object)(messageQualifier + "get" + capitalCamelName + "Bytes"));
                    fieldNames.add((Object)(builderQualifier + "get" + capitalCamelName + "Bytes"));
                    fieldNames.add((Object)(builderQualifier + "set" + capitalCamelName + "Bytes"));
                } else if (PbPsiUtil.fieldIsMessage(field)) {
                    for (FieldFormat fmt : RepeatedFields.IMMUTABLE_MESSAGE_FIELD_FORMATS) {
                        fieldNames.add((Object)fmt.getName(messageQualifier, capitalCamelName));
                        fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
                    }
                    for (FieldFormat fmt : RepeatedFields.MUTABLE_MESSAGE_FIELD_FORMATS) {
                        fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
                    }
                }
            }
        } else {
            for (FieldFormat fmt : SingularFields.IMMUTABLE_FIELD_FORMATS) {
                fieldNames.add((Object)fmt.getName(messageQualifier, capitalCamelName));
                fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
            }
            FieldFormat[] builtInType = SingularFields.MUTABLE_FIELD_FORMATS;
            int n = builtInType.length;
            for (int i = 0; i < n; ++i) {
                FieldFormat fmt;
                fmt = builtInType[i];
                fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
            }
            FieldFormat[] fieldFormatArray = builtInType = field.getTypeName() != null ? field.getTypeName().getBuiltInType() : null;
            if (builtInType != null && builtInType.equals((Object)BuiltInType.STRING)) {
                fieldNames.add((Object)(messageQualifier + "get" + capitalCamelName + "Bytes"));
                fieldNames.add((Object)(builderQualifier + "get" + capitalCamelName + "Bytes"));
                fieldNames.add((Object)(builderQualifier + "set" + capitalCamelName + "Bytes"));
            } else if (PbPsiUtil.fieldIsMessage(field)) {
                for (FieldFormat fmt : SingularFields.IMMUTABLE_MESSAGE_FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(messageQualifier, capitalCamelName));
                    fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
                }
                for (FieldFormat fmt : SingularFields.MUTABLE_MESSAGE_FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(builderQualifier, capitalCamelName));
                }
            }
        }
        fieldNames.add((Object)(messageQualifier + Proto2NameGenerator.fieldConstantName(fieldName)));
        return fieldNames.build();
    }

    @Override
    @Nullable
    public String enumClassName(PbEnumDefinition enumDefinition) {
        return this.proto2DefinitionClassNames.enumClassName(enumDefinition);
    }

    @Override
    @Nullable
    public String enumValueName(PbEnumValue enumValue) {
        return enumValue.getName();
    }

    @Override
    public Set<String> oneofMemberNames(PbOneofDefinition oneof) {
        if (oneof.getName() == null) {
            return ImmutableSet.of();
        }
        String oneofName = oneof.getName();
        String capitalCamelName = NameUtils.underscoreToCapitalizedCamelCase(oneofName);
        return ImmutableSet.of((Object)String.format("get%sCase", capitalCamelName), (Object)String.format("Builder.clear%s", capitalCamelName));
    }

    @Override
    @Nullable
    public String oneofEnumClassName(PbOneofDefinition oneof) {
        return this.proto2DefinitionClassNames.oneofEnumClassName(oneof);
    }

    @Override
    @Nullable
    public String oneofNotSetEnumValueName(PbOneofDefinition oneof) {
        String name = oneof.getName();
        if (name == null) {
            return null;
        }
        String camelFullUpper = Ascii.toUpperCase((String)NameUtils.underscoreToCapitalizedCamelCase(name));
        return camelFullUpper + "_NOT_SET";
    }

    @Override
    @Nullable
    public String oneofEnumValueName(PbField oneofField) {
        String name = oneofField.getName();
        return name != null ? Ascii.toUpperCase((String)name) : null;
    }

    @Override
    public NameMatcher toNameMatcher(PbJavaGotoDeclarationContext context) {
        return new Proto2NameMatcher(context, this);
    }

    private static final class MapFields {
        private static final FieldFormat[] IMMUTABLE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sget%sOrDefault"), new FieldFormat("%sget%sOrThrow"), new FieldFormat("%scontains%s"), new FieldFormat("%sget%sCount"), new FieldFormat("%sget%sMap"), new FieldFormat("%sget%s")};
        private static final FieldFormat[] MUTABLE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sclear%s"), new FieldFormat("%sremove%s"), new FieldFormat("%sput%s"), new FieldFormat("%sputAll%s")};

        private MapFields() {
        }
    }

    private static final class RepeatedFields {
        private static final FieldFormat[] IMMUTABLE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sget%s"), new FieldFormat("%sget%sCount"), new FieldFormat("%sget%sList")};
        private static final FieldFormat[] MUTABLE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sset%s"), new FieldFormat("%sadd%s"), new FieldFormat("%sadd%sBuilder"), new FieldFormat("%saddAll%s"), new FieldFormat("%sclear%s")};
        private static final FieldFormat[] IMMUTABLE_MESSAGE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sget%sOrBuilder"), new FieldFormat("%sget%sOrBuilderList")};
        private static final FieldFormat[] MUTABLE_MESSAGE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sget%sBuilder"), new FieldFormat("%sget%sFieldBuilder"), new FieldFormat("%sget%sBuilderList"), new FieldFormat("%sremove%s")};

        private RepeatedFields() {
        }
    }

    private static final class SingularFields {
        private static final FieldFormat[] IMMUTABLE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%shas%s"), new FieldFormat("%sget%s")};
        private static final FieldFormat[] MUTABLE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sset%s"), new FieldFormat("%sclear%s")};
        private static final FieldFormat[] IMMUTABLE_MESSAGE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sget%sOrBuilder")};
        private static final FieldFormat[] MUTABLE_MESSAGE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("%sget%sBuilder"), new FieldFormat("%sget%sFieldBuilder"), new FieldFormat("%smerge%s")};

        private SingularFields() {
        }
    }

    private static final class FieldFormat {
        private final String format;

        FieldFormat(String format) {
            this.format = format;
        }

        String getName(String builderOrMessageBase, String fieldName) {
            return String.format(this.format, builderOrMessageBase, fieldName);
        }
    }
}

