/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.names;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.intellij.protobuf.jvm.PbJavaGotoDeclarationContext;
import com.intellij.protobuf.jvm.names.GeneratorBasedNameMatcher;
import com.intellij.protobuf.jvm.names.NameGenerator;
import com.intellij.protobuf.jvm.names.NameMatcher;
import com.intellij.protobuf.jvm.names.NameUtils;
import com.intellij.protobuf.jvm.names.Proto2DefinitionClassNames;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.lang.util.BuiltInType;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Proto2MutableNameGenerator
implements NameGenerator {
    private final Proto2DefinitionClassNames proto2DefinitionClassNames;

    Proto2MutableNameGenerator(PbFile file, String descriptorPackage, String multiFilePackage, String outerClassName, boolean isMultipleFiles) {
        String classPrefix;
        String classPackage;
        if (isMultipleFiles && !multiFilePackage.isEmpty()) {
            classPackage = multiFilePackage;
            classPrefix = ".";
        } else {
            isMultipleFiles = false;
            classPackage = descriptorPackage;
            classPrefix = ".Mutable";
        }
        this.proto2DefinitionClassNames = new Proto2DefinitionClassNames(file, file.getPackageQualifiedName(), descriptorPackage, classPackage, classPrefix, outerClassName, isMultipleFiles);
    }

    @Override
    public Set<String> outerClassNames() {
        return this.proto2DefinitionClassNames.outerClassNames(this);
    }

    @Override
    public Set<String> messageClassNames(PbMessageType messageType) {
        String baseName = this.proto2DefinitionClassNames.messageClassName(messageType);
        return baseName != null ? ImmutableSet.of((Object)baseName) : ImmutableSet.of();
    }

    private static String fieldConstantName(String fieldName) {
        return Ascii.toUpperCase((String)fieldName) + "_FIELD_NUMBER";
    }

    @Override
    public Set<String> fieldMemberNames(PbField field) {
        if (field.getName() == null) {
            return ImmutableSet.of();
        }
        String fieldName = NameGenerator.fieldName(field);
        ImmutableSet.Builder fieldNames = ImmutableSet.builder();
        String capitalCamelName = NameUtils.underscoreToCapitalizedCamelCase(fieldName);
        if (field.isRepeated()) {
            if (field instanceof PbMapField) {
                for (FieldFormat fmt : MapFields.FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(capitalCamelName));
                }
            } else {
                BuiltInType builtInType;
                for (FieldFormat fmt : RepeatedFields.FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(capitalCamelName));
                }
                BuiltInType builtInType2 = builtInType = field.getTypeName() != null ? field.getTypeName().getBuiltInType() : null;
                if (builtInType != null && builtInType.equals((Object)BuiltInType.STRING)) {
                    for (FieldFormat fmt : RepeatedFields.STRING_FIELD_FORMATS) {
                        fieldNames.add((Object)fmt.getName(capitalCamelName));
                    }
                } else if (PbPsiUtil.fieldIsMessage(field)) {
                    for (FieldFormat fmt : RepeatedFields.MESSAGE_FIELD_FORMATS) {
                        fieldNames.add((Object)fmt.getName(capitalCamelName));
                    }
                }
            }
        } else {
            FieldFormat[] builtInType = SingularFields.FIELD_FORMATS;
            int n = builtInType.length;
            for (int i = 0; i < n; ++i) {
                FieldFormat fmt = builtInType[i];
                fieldNames.add((Object)fmt.getName(capitalCamelName));
            }
            FieldFormat[] fieldFormatArray = builtInType = field.getTypeName() != null ? field.getTypeName().getBuiltInType() : null;
            if (builtInType != null && builtInType.equals((Object)BuiltInType.STRING)) {
                for (FieldFormat fmt : SingularFields.STRING_FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(capitalCamelName));
                }
            } else if (PbPsiUtil.fieldIsMessage(field)) {
                for (FieldFormat fmt : SingularFields.MESSAGE_FIELD_FORMATS) {
                    fieldNames.add((Object)fmt.getName(capitalCamelName));
                }
            }
        }
        fieldNames.add((Object)Proto2MutableNameGenerator.fieldConstantName(fieldName));
        return fieldNames.build();
    }

    @Override
    @Nullable
    public String enumClassName(PbEnumDefinition enumDefinition) {
        return this.proto2DefinitionClassNames.enumClassName(enumDefinition);
    }

    @Override
    @Nullable
    public String enumValueName(PbEnumValue enumValue) {
        return enumValue.getName();
    }

    @Override
    public Set<String> oneofMemberNames(PbOneofDefinition oneof) {
        if (oneof.getName() == null) {
            return ImmutableSet.of();
        }
        String oneofName = oneof.getName();
        String capitalCamelName = NameUtils.underscoreToCapitalizedCamelCase(oneofName);
        return ImmutableSet.of((Object)String.format("get%sCase", capitalCamelName), (Object)String.format("clear%s", capitalCamelName));
    }

    @Override
    @Nullable
    public String oneofEnumClassName(PbOneofDefinition oneof) {
        return this.proto2DefinitionClassNames.oneofEnumClassName(oneof);
    }

    @Override
    @Nullable
    public String oneofNotSetEnumValueName(PbOneofDefinition oneof) {
        String name = oneof.getName();
        if (name == null) {
            return null;
        }
        String camelFullUpper = Ascii.toUpperCase((String)NameUtils.underscoreToCapitalizedCamelCase(name));
        return camelFullUpper + "_NOT_SET";
    }

    @Override
    @Nullable
    public String oneofEnumValueName(PbField oneofField) {
        String name = oneofField.getName();
        return name != null ? Ascii.toUpperCase((String)name) : null;
    }

    @Override
    public NameMatcher toNameMatcher(PbJavaGotoDeclarationContext context) {
        return new GeneratorBasedNameMatcher(context, this);
    }

    private static final class MapFields {
        private static final FieldFormat[] FIELD_FORMATS = new FieldFormat[]{new FieldFormat("get%s"), new FieldFormat("getMutable%s"), new FieldFormat("putAll%s")};

        private MapFields() {
        }
    }

    private static final class RepeatedFields {
        private static final FieldFormat[] FIELD_FORMATS = new FieldFormat[]{new FieldFormat("get%s"), new FieldFormat("get%sCount"), new FieldFormat("get%sList"), new FieldFormat("getMutable%sList"), new FieldFormat("set%s"), new FieldFormat("add%s"), new FieldFormat("addAll%s"), new FieldFormat("clear%s")};
        private static final FieldFormat[] MESSAGE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("getMutable%s")};
        private static final FieldFormat[] STRING_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("get%sAsBytes"), new FieldFormat("get%sListAsBytes"), new FieldFormat("add%sAsBytes"), new FieldFormat("set%sAsBytes")};

        private RepeatedFields() {
        }
    }

    private static final class SingularFields {
        private static final FieldFormat[] FIELD_FORMATS = new FieldFormat[]{new FieldFormat("has%s"), new FieldFormat("get%s"), new FieldFormat("set%s"), new FieldFormat("clear%s")};
        private static final FieldFormat[] MESSAGE_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("getMutable%s")};
        private static final FieldFormat[] STRING_FIELD_FORMATS = new FieldFormat[]{new FieldFormat("get%sAsBytes"), new FieldFormat("set%sAsBytes")};

        private SingularFields() {
        }
    }

    private static final class FieldFormat {
        private final String format;

        FieldFormat(String format) {
            this.format = format;
        }

        String getName(String fieldName) {
            return String.format(this.format, fieldName);
        }
    }
}

