/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.names;

import com.google.common.collect.ImmutableSet;
import com.intellij.protobuf.jvm.PbJavaGotoDeclarationContext;
import com.intellij.protobuf.jvm.names.GeneratorBasedNameMatcher;
import com.intellij.protobuf.jvm.names.NameGenerator;
import com.intellij.protobuf.jvm.names.NameMatcher;
import com.intellij.protobuf.jvm.names.NameUtils;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbMessageDefinition;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.lang.util.BuiltInType;
import com.intellij.psi.util.QualifiedName;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Proto1NameGenerator
implements NameGenerator {
    private final PbFile file;
    private final String javaPackage;
    private final QualifiedName protoPackage;

    Proto1NameGenerator(PbFile file, String javaPackage) {
        this.file = file;
        this.javaPackage = javaPackage;
        this.protoPackage = file.getPackageQualifiedName();
    }

    @Override
    public Set<String> outerClassNames() {
        ImmutableSet.Builder names = ImmutableSet.builder();
        for (PbSymbol symbol : this.file.getLocalQualifiedSymbolMap().values()) {
            if (!(symbol instanceof PbMessageDefinition)) continue;
            names.addAll(this.messageClassNames((PbMessageDefinition)symbol));
        }
        return names.build();
    }

    @Override
    public Set<String> messageClassNames(PbMessageType messageType) {
        QualifiedName messageName = messageType.getQualifiedName();
        if (messageName == null) {
            return ImmutableSet.of();
        }
        QualifiedName fileLocalQualifiers = messageName.removeHead(this.protoPackage.getComponentCount());
        String name = messageType instanceof PbMessageDefinition ? this.typeNameOwnFile(fileLocalQualifiers) : this.typeNameNestedInFile(fileLocalQualifiers);
        return ImmutableSet.of((Object)name);
    }

    private String typeNameOwnFile(QualifiedName localName) {
        return this.javaPackage + "." + localName.join("_");
    }

    private String typeNameNestedInFile(QualifiedName localName) {
        return this.javaPackage + "." + localName;
    }

    @Override
    public Set<String> fieldMemberNames(PbField field) {
        if (field.getName() == null) {
            return ImmutableSet.of();
        }
        String fieldName = NameGenerator.fieldName(field);
        ImmutableSet.Builder fieldNames = ImmutableSet.builder();
        String camelName = NameUtils.underscoreToCamelCase(fieldName);
        String capitalCamelName = NameUtils.underscoreToCapitalizedCamelCase(fieldName);
        if (field.isRepeated()) {
            BuiltInType builtInType;
            BuiltInType builtInType2 = builtInType = field.getTypeName() != null ? field.getTypeName().getBuiltInType() : null;
            if (builtInType != null && builtInType.getName().equals("bool")) {
                fieldNames.add((Object)("is" + capitalCamelName));
            } else {
                fieldNames.add((Object)("get" + capitalCamelName));
            }
            fieldNames.add((Object)("set" + capitalCamelName));
            fieldNames.add((Object)("clear" + capitalCamelName));
            fieldNames.add((Object)(camelName + "Iterator"));
            fieldNames.add((Object)(camelName + "s"));
            fieldNames.add((Object)(camelName + "Size"));
            fieldNames.add((Object)("add" + capitalCamelName));
            if (builtInType != null) {
                switch (builtInType.getName()) {
                    case "string": 
                    case "bytes": {
                        fieldNames.add((Object)(camelName + "sAsBytes"));
                        fieldNames.add((Object)(camelName + "AsBytesIterator"));
                        fieldNames.add((Object)("add" + capitalCamelName + "AsBytes"));
                        fieldNames.add((Object)("get" + capitalCamelName + "AsBytes"));
                        fieldNames.add((Object)("set" + capitalCamelName + "AsBytes"));
                        break;
                    }
                }
            } else if (PbPsiUtil.fieldIsMessage(field) || field instanceof PbMapField) {
                fieldNames.add((Object)("insert" + capitalCamelName));
                fieldNames.add((Object)("remove" + capitalCamelName));
            }
            fieldNames.add((Object)("mutable" + capitalCamelName + "s"));
            fieldNames.add((Object)("getMutable" + capitalCamelName));
        } else {
            BuiltInType builtInType = field.getTypeName() != null ? field.getTypeName().getBuiltInType() : null;
            fieldNames.add((Object)("has" + capitalCamelName));
            if (builtInType != null && builtInType.getName().equals("bool")) {
                fieldNames.add((Object)("is" + capitalCamelName));
            } else {
                fieldNames.add((Object)("get" + capitalCamelName));
            }
            fieldNames.add((Object)("set" + capitalCamelName));
            fieldNames.add((Object)("clear" + capitalCamelName));
            if (builtInType != null) {
                switch (builtInType.getName()) {
                    case "string": 
                    case "bytes": {
                        fieldNames.add((Object)("get" + capitalCamelName + "AsBytes"));
                        fieldNames.add((Object)("set" + capitalCamelName + "AsBytes"));
                        break;
                    }
                }
            } else if (PbPsiUtil.fieldIsMessage(field)) {
                fieldNames.add((Object)("getMutable" + capitalCamelName));
            }
        }
        return fieldNames.build();
    }

    @Override
    @Nullable
    public String enumClassName(PbEnumDefinition enumDefinition) {
        return null;
    }

    @Override
    @Nullable
    public String enumValueName(PbEnumValue enumValue) {
        return null;
    }

    @Override
    public Set<String> oneofMemberNames(PbOneofDefinition oneof) {
        return ImmutableSet.of();
    }

    @Override
    @Nullable
    public String oneofEnumClassName(PbOneofDefinition oneof) {
        return null;
    }

    @Override
    @Nullable
    public String oneofNotSetEnumValueName(PbOneofDefinition oneof) {
        return null;
    }

    @Override
    @Nullable
    public String oneofEnumValueName(PbField oneofField) {
        return null;
    }

    @Override
    public NameMatcher toNameMatcher(PbJavaGotoDeclarationContext context) {
        return new GeneratorBasedNameMatcher(context, this);
    }
}

