/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.names;

import com.intellij.openapi.util.Ref;
import com.intellij.protobuf.jvm.names.NameGenerator;
import com.intellij.protobuf.jvm.names.Proto1NameGenerator;
import com.intellij.protobuf.jvm.names.Proto2DefinitionClassNames;
import com.intellij.protobuf.jvm.names.Proto2MutableNameGenerator;
import com.intellij.protobuf.jvm.names.Proto2NameGenerator;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbIdentifierValue;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbStringValue;
import java.util.ArrayList;
import java.util.List;

public class NameGeneratorSelector {
    public static List<NameGenerator> selectForFile(PbFile file) {
        Ref javaApiVersion = Ref.create((Object)2);
        Ref javaPackage = Ref.create();
        Ref javaOuterClassname = Ref.create();
        Ref javaMultipleFiles = Ref.create((Object)false);
        Ref javaMutableApi = Ref.create((Object)false);
        Ref javaMultipleFilesMutablePackage = Ref.create();
        ArrayList<NameGenerator> generators = new ArrayList<NameGenerator>();
        for (PbOptionExpression optionExpression : file.getOptions()) {
            String optionName;
            switch (optionName = optionExpression.getOptionName().getText()) {
                case "java_package": {
                    NameGeneratorSelector.parseStringOption(optionExpression, (Ref<String>)javaPackage);
                    break;
                }
                case "java_outer_classname": {
                    NameGeneratorSelector.parseStringOption(optionExpression, (Ref<String>)javaOuterClassname);
                    break;
                }
                case "java_multiple_files": {
                    NameGeneratorSelector.parseBoolOption(optionExpression, (Ref<Boolean>)javaMultipleFiles);
                    break;
                }
            }
        }
        if ((Integer)javaApiVersion.get() == 1) {
            generators.add(new Proto1NameGenerator(file, (String)javaPackage.get()));
        } else if ((Integer)javaApiVersion.get() == 2) {
            if (javaOuterClassname.isNull()) {
                javaOuterClassname.set((Object)Proto2DefinitionClassNames.getDefaultOuterClassName(file));
            }
            if (((Boolean)javaMutableApi.get()).booleanValue()) {
                if (javaMultipleFilesMutablePackage.isNull()) {
                    javaMultipleFilesMutablePackage.set((Object)"");
                }
                generators.add(new Proto2MutableNameGenerator(file, (String)javaPackage.get(), (String)javaMultipleFilesMutablePackage.get(), (String)javaOuterClassname.get(), (Boolean)javaMultipleFiles.get()));
            } else {
                generators.add(new Proto2NameGenerator(file, (String)javaPackage.get(), (String)javaOuterClassname.get(), (Boolean)javaMultipleFiles.get()));
            }
        }
        return generators;
    }

    private static void parseIntOption(PbOptionExpression optionExpression, Ref<Integer> outValue) {
        PbNumberValue numberValue = optionExpression.getNumberValue();
        if (numberValue == null) {
            return;
        }
        if (numberValue.getLongValue() != null) {
            outValue.set((Object)numberValue.getLongValue().intValue());
        }
    }

    private static void parseStringOption(PbOptionExpression optionExpression, Ref<String> outValue) {
        PbStringValue stringValue = optionExpression.getStringValue();
        if (stringValue == null) {
            return;
        }
        outValue.set((Object)stringValue.getAsString());
    }

    private static void parseBoolOption(PbOptionExpression optionExpression, Ref<Boolean> outValue) {
        PbIdentifierValue boolAsIdentifier = optionExpression.getIdentifierValue();
        if (boolAsIdentifier == null) {
            return;
        }
        Boolean value = boolAsIdentifier.getBooleanValue();
        if (value == null) {
            return;
        }
        outValue.set((Object)value);
    }
}

