/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.jvm.names.NameGenerator;
import com.intellij.protobuf.jvm.names.NameGeneratorSelector;
import com.intellij.protobuf.lang.PbFileType;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PbJavaOuterClassIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> INDEX_ID = ID.create((String)"protoeditor.java.outer.class.index");
    private static final DataIndexer<String, Void, FileContent> INDEXER_INSTANCE = new OuterClassNameIndexer();

    public static Collection<PbFile> getFilesWithOuterClass(Project project, String outerClassName, GlobalSearchScope scope) {
        Collection files = FileBasedIndex.getInstance().getContainingFiles(INDEX_ID, (Object)outerClassName, scope);
        return files.stream().map(f -> (PbFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(f), PbFile.class)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{PbFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file.isInLocalFileSystem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/protobuf/jvm/PbJavaOuterClassIndex$1", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = INDEX_ID;
        if (iD == null) {
            PbJavaOuterClassIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = INDEXER_INSTANCE;
        if (dataIndexer == null) {
            PbJavaOuterClassIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PbJavaOuterClassIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    public int getVersion() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/protobuf/jvm/PbJavaOuterClassIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class OuterClassNameIndexer
    implements DataIndexer<String, Void, FileContent> {
        private OuterClassNameIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            PbFile pbFile;
            if (inputData == null) {
                OuterClassNameIndexer.$$$reportNull$$$0(0);
            }
            if ((pbFile = (PbFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PbFile.class)) == null) {
                Map<String, Void> map = Collections.emptyMap();
                if (map == null) {
                    OuterClassNameIndexer.$$$reportNull$$$0(1);
                }
                return map;
            }
            Collection<String> outerClassNames = this.computeOuterClassNames(pbFile);
            HashMap<String, Void> result = new HashMap<String, Void>();
            for (String outerClassName : outerClassNames) {
                result.put(outerClassName, null);
            }
            HashMap<String, Void> hashMap = result;
            if (hashMap == null) {
                OuterClassNameIndexer.$$$reportNull$$$0(2);
            }
            return hashMap;
        }

        @NotNull
        private Collection<String> computeOuterClassNames(PbFile file) {
            List<NameGenerator> nameGenerators = NameGeneratorSelector.selectForFile(file);
            ArrayList<String> results = new ArrayList<String>();
            for (NameGenerator nameGenerator : nameGenerators) {
                results.addAll(nameGenerator.outerClassNames());
            }
            ArrayList<String> arrayList = results;
            if (arrayList == null) {
                OuterClassNameIndexer.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/protobuf/jvm/PbJavaOuterClassIndex$OuterClassNameIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/protobuf/jvm/PbJavaOuterClassIndex$OuterClassNameIndexer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeOuterClassNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

