/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm;

import com.intellij.protobuf.jvm.PbJavaGotoDeclarationContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbJavaGotoReferenceMatch {
    private static final String PROTO2_PACKAGE = "com.google.protobuf";
    private static final String PROTO2_PACKAGE_WITH_DOT = "com.google.protobuf.";
    private static final String PROTO1_PACKAGE = "com.google.io.protocol";
    private static final String PROTO1_PACKAGE_WITH_DOT = "com.google.io.protocol.";

    @Nullable
    public static PbJavaGotoDeclarationContext isFromProto(PsiElement resolvedReference) {
        PsiNamedElement resolved = (PsiNamedElement)ObjectUtils.tryCast((Object)resolvedReference, PsiNamedElement.class);
        if (resolved == null) {
            return null;
        }
        PsiClass classContext = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)resolved, PsiClass.class, (boolean)false);
        if (classContext == null || !PbJavaGotoReferenceMatch.isPbGeneratedDefinition(classContext)) {
            return null;
        }
        PsiClass fileClass = PbJavaGotoReferenceMatch.getFileClass(classContext);
        if (fileClass.getQualifiedName() == null) {
            return null;
        }
        return new PbJavaGotoDeclarationContext(resolved, classContext, fileClass);
    }

    @NotNull
    private static PsiClass getFileClass(@NotNull PsiClass definitionClass) {
        if (definitionClass == null) {
            PbJavaGotoReferenceMatch.$$$reportNull$$$0(0);
        }
        PsiClass containingClass = definitionClass;
        while (true) {
            PsiClass next;
            if ((next = containingClass.getContainingClass()) == null) {
                PsiClass psiClass = containingClass;
                if (psiClass == null) {
                    PbJavaGotoReferenceMatch.$$$reportNull$$$0(1);
                }
                return psiClass;
            }
            containingClass = next;
        }
    }

    private static boolean isPbGeneratedDefinition(PsiClass psiClass) {
        if (psiClass.getContainingClass() != null && PbJavaGotoReferenceMatch.isPbGeneratedDefinition(psiClass.getContainingClass())) {
            return true;
        }
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        return PbJavaGotoReferenceMatch.derivesFromProto(psiClass.getExtendsListTypes(), visited) || PbJavaGotoReferenceMatch.derivesFromProto(psiClass.getImplementsListTypes(), visited);
    }

    private static boolean derivesFromProto(PsiClassType[] superTypes, Set<PsiClass> visited) {
        return Arrays.stream(superTypes).anyMatch(classType -> PbJavaGotoReferenceMatch.isProtoClass(classType, visited));
    }

    private static boolean isProtoClass(PsiClassType superType, Set<PsiClass> visited) {
        PsiClass resolved = superType.resolve();
        if (resolved == null) {
            return false;
        }
        if (!visited.add(resolved)) {
            return false;
        }
        String qualifiedName = resolved.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (qualifiedName.startsWith(PROTO2_PACKAGE_WITH_DOT) || qualifiedName.startsWith(PROTO1_PACKAGE_WITH_DOT)) {
            return true;
        }
        return PbJavaGotoReferenceMatch.derivesFromProto(resolved.getExtendsListTypes(), visited) || PbJavaGotoReferenceMatch.derivesFromProto(resolved.getImplementsListTypes(), visited);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/jvm/PbJavaGotoReferenceMatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/jvm/PbJavaGotoReferenceMatch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileClass";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

